/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ReflectUtil {
    public static List<Field> findAllFields(Class entityClass, boolean includeParent) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields = entityClass.getFields()) {
            list.add(field);
        }
        return list;
    }

    public static Field getAllDeclaredFields(Class entityClass, String fileName, boolean includeParent) {
        Class superclass;
        Field[] fields;
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(fileName)) continue;
            return field;
        }
        if (includeParent && (superclass = entityClass.getSuperclass()) != null) {
            return ReflectUtil.getAllDeclaredFields(superclass, fileName, includeParent);
        }
        return null;
    }

    public static List<Field> findAllDeclaredFields(Class entityClass, boolean includeParent) {
        Class superclass;
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            list.add(field);
        }
        if (includeParent && (superclass = entityClass.getSuperclass()) != null) {
            List<Field> allDeclaredFields = ReflectUtil.findAllDeclaredFields(superclass, includeParent);
            list.addAll(allDeclaredFields);
        }
        return list;
    }

    public static Type getGenericClassParameterizedType(Class classz) {
        return ReflectUtil.getGenericClassParameterizedType(classz, 0);
    }

    public static Type getGenericClassParameterizedType(Class classz, int index) {
        Class superclass;
        Type type = classz.getGenericSuperclass();
        if (!(type instanceof ParameterizedType) && (superclass = classz.getSuperclass()) != null) {
            type = superclass.getGenericSuperclass();
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return null;
    }

    public static Method getGetMethodByField(Class objectClass, String fieldName) {
        Field field = null;
        try {
            field = objectClass.getField(fieldName);
            if (field == null) {
                field = objectClass.getDeclaredField(fieldName);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field == null) {
            try {
                field = objectClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (field == null) {
            throw new IllegalArgumentException("not find field " + fieldName + " for class " + objectClass.toString());
        }
        return ReflectUtil.getGetMethodByField(objectClass, field);
    }

    public static Method getGetMethodByField(Class objectClass, Field field) {
        return ReflectUtil.getGetMethodByField(objectClass, field.getType(), field.getName());
    }

    public static Method getGetMethodByField(Class objectClass, Class fieldClass, String fieldName) {
        StringBuffer sb = new StringBuffer();
        if (fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Boolean.class)) {
            sb.append("is");
        } else {
            sb.append("get");
        }
        sb.append(fieldName.substring(0, 1).toUpperCase());
        sb.append(fieldName.substring(1));
        try {
            return objectClass.getMethod(sb.toString(), new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method getSetMethodByField(Class objectClass, String fieldName) {
        try {
            Class[] parameterTypes = new Class[1];
            Field field = objectClass.getDeclaredField(fieldName);
            parameterTypes[0] = field.getType();
            StringBuffer sb = new StringBuffer();
            sb.append("set");
            sb.append(fieldName.substring(0, 1).toUpperCase());
            sb.append(fieldName.substring(1));
            Method method = objectClass.getMethod(sb.toString(), parameterTypes);
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void invokeSetByField(Object o, String fieldName, Object value) {
        Method method = ReflectUtil.getSetMethodByField(o.getClass(), fieldName);
        try {
            method.invoke(o, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object invokeGetByField(Object o, String fieldName) {
        Method method = ReflectUtil.getGetMethodByField(o.getClass(), fieldName);
        try {
            return method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Annotation[] getClassAnnotations(Class<?> aClass) {
        return aClass.getAnnotations();
    }

    public static <ANNOTATION extends Annotation> ANNOTATION getClassAnnotation(Class<?> aClass, Class<ANNOTATION> annotationClass) {
        return aClass.getAnnotation(annotationClass);
    }

    public static Annotation[] getMethodAnnotations(Method method) {
        return method.getAnnotations();
    }

    public static <ANNOTATION extends Annotation> ANNOTATION getMethodAnnotation(Method method, Class<ANNOTATION> annotationClass) {
        return method.getAnnotation(annotationClass);
    }

    public static Annotation[] getFieldAnnotations(Field field) {
        return field.getAnnotations();
    }

    public static <ANNOTATION extends Annotation> ANNOTATION getFieldAnnotation(Field field, Class<ANNOTATION> annotationClass) {
        return field.getAnnotation(annotationClass);
    }
}

