package cn.net.vidyo.framework.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * User: 马生录（mason
 * Date: 13-10-8
 * Time: 下午5:02
 */
public class ValueUtil {

    public static void putMapMoneyItem(Map data,String key,long money){
        putMapMoneyItem(data, key, money,true);
    }
    public static void putMapMoneyItem(Map data,String key,long money,boolean isAddMoneyString){
        data.put(key,money);
        if(isAddMoneyString){
            data.put(key+"String",money100IntToStringMoney(money));
        }
    }

    public static String convertTimeToString(long time){
        if(time==0) return "";
        Date date=new Date(time);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String format = f.format(date);
        return format;
    }
    public static boolean checkIsNumber(String content) {
        try {
            Double num1 = Double.parseDouble(content);
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }
    public static Date UTCToCST(String UTCStr) throws ParseException {
        return UTCToCST(UTCStr, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static Date UTCToCST(String UTCStr, String format) throws ParseException {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        date = sdf.parse(UTCStr);
        System.out.println("UTC时间: " + date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR, calendar.get(Calendar.HOUR) + 8);
        //calendar.getTime() 返回的是Date类型，也可以使用calendar.getTimeInMillis()获取时间戳
        return calendar.getTime();
    }

    public static String convertMoneyString(int money) {
        double d = money / 100;
        return String.valueOf(d);
    }

    public static long convertStringToMoneyLong(String content) {
        double v = toDouble(content, 0L);
        v = v * 100;
        return (long) v;
    }

    public static String convertMoneyLongToMoneyString(long money) {
        double val = money;
        val = val / 100;
        String content = String.valueOf(val);
        if (content.indexOf(".") < 0) {
            content = content + ".00";
        }
        if (content.endsWith(".0")) {
            content = content + "0";
        }
        content = "¥" + content;
        return content;
    }

    public static String convertMoneyLongToNegativeMoneyString(long money) {
        double val = money;
        val = val / 100;
        String content = String.valueOf(val);
        if (content.indexOf(".") < 0) {
            content = content + ".00";
        }
        if (content.endsWith(".0")) {
            content = content + "0";
        }
        content = "¥-" + content;
        return content;
    }

    //<editor-fold desc="Extend Map item">


//    public static int mapItemToMoneyLong(Map data, String key) {
//        return mapItemToMoneyLong(data, key, 0);
//    }
//
//    public static int mapItemToMoneyLong(Map data, String key, int defaultValue) {
//        String s = mapItemToString(data, key);
//        if (s.length() == 0) {
//            return defaultValue;
//        }
//        double val = Double.valueOf(s);
//        val = val * 100;
//        return (int) val;
//    }

    public static Date mapItemToDate(Map data, String key, Date defaultValue) {
        String content = mapItemToString(data, key, "");
        if (content.length() == 0) {
            return defaultValue;
        }
        if (content.length() < 10) {
            return defaultValue;
        }
        try {
            return UTCToCST(content);
        } catch (ParseException e) {
            return defaultValue;
        }
    }
//    public static String mapItemToStringDate(Map data, String key, String defaultValue) {
//        //2021-07-13T16:13:28.362Z
//        String content = mapItemToString(data, key, "");
//        if(content==null || content.length()==0){
//            return defaultValue;
//        }
//        if(content.length()<10){
//            return defaultValue;
//        }
//        content= content.substring(0,10);
//        content=content.replace("-","");
//        return content;
//    }

//    /**
//     *
//     * <p>Description: 本地时间转化为UTC时间</p>
//     * @param localTime
//     * @return
//     * @author wgs
//     * @date  2018年10月19日 下午2:23:43
//     *
//     */
//    public static Date localToUTC(String localTime) {
//        DateTimeUtil.par
//        SimpleDateFormat localFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
////        SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
//        try {
//            localFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
//            Date date = localFormat.parse(localTime);
//            return date;
//        } catch (ParseException e) {
//            return new Date();
//        }
////        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
////        Date localDate= null;
////        try {
////            localDate = sdf.parse(localTime);
////        } catch (ParseException e) {
////            e.printStackTrace();
////        }
////        long localTimeInMillis=localDate.getTime();
////        /** long时间转换成Calendar */
////        Calendar calendar= Calendar.getInstance();
////        calendar.setTimeInMillis(localTimeInMillis);
////        /** 取得时间偏移量 */
////        int zoneOffset = calendar.get(java.util.Calendar.ZONE_OFFSET);
////        /** 取得夏令时差 */
////        int dstOffset = calendar.get(java.util.Calendar.DST_OFFSET);
////        /** 从本地时间里扣除这些差量，即可以取得UTC时间*/
////        calendar.add(java.util.Calendar.MILLISECOND, -(zoneOffset + dstOffset));
////        /** 取得的时间就是UTC标准时间 */
////        Date utcDate=new Date(calendar.getTimeInMillis());
////        return utcDate;
//    }

//    /**
//     *
//     * <p>Description:UTC时间转化为本地时间 </p>
//     * @param utcTime
//     * @return
//     * @author wgs
//     * @date  2018年10月19日 下午2:23:24
//     *
//     */
//    public static Date utcToLocal(String utcTime){
////        SimpleDateFormat localFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
////        SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
//        SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy/MM/dd");
//        try {
////            utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
//            Date date = utcFormat.parse(utcTime);
//            return date;
//        } catch (ParseException e) {
//            return new Date();
//        }
////        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
////        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
////        Date utcDate = null;
////        try {
////            utcDate = sdf.parse(utcTime);
////        } catch (ParseException e) {
////            e.printStackTrace();
////        }
////        sdf.setTimeZone(TimeZone.getDefault());
////        Date locatlDate = null;
////        String localTime = sdf.format(utcDate.getTime());
////        try {
////            locatlDate = sdf.parse(localTime);
////        } catch (ParseException e) {
////            e.printStackTrace();
////        }
////        return locatlDate;
//    }
    //</editor-fold>

    //<editor-fold desc="BASE Map Item">
    public static int mapItemToInt(Map data, String key) {
        return mapItemToInt(data, key, 0);
    }

    public static int mapItemToInt(Map data, String key, int defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return toInt(data.get(key), defaultValue);
    }

    public static long mapItemToLong(Map data, String key) {
        return mapItemToLong(data, key, 0);
    }

    public static long mapItemToLong(Map data, String key, long defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return toLong(data.get(key), defaultValue);
    }

    public static boolean mapItemToBool(Map data, String key) {
        return mapItemToBool(data, key, false);
    }

    public static boolean mapItemToBool(Map data, String key, boolean defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return toBool(data.get(key), defaultValue);
    }

    public static String mapItemToString(Map data, String key) {
        return mapItemToString(data, key, "");
    }

    public static String mapItemToString(Map data, String key, String defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return data.get(key).toString();
    }

    public static double mapItemToDouble(Map data, String key) {
        return mapItemToDouble(data, key, 0);
    }

    public static double mapItemToDouble(Map data, String key, double defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return toDouble(data.get(key), defaultValue);
    }

    public static Date mapItemToStandardDate(Map data, String key) {
        return mapItemToStandardDate(data, key, null);
    }

    public static Date mapItemToStandardDate(Map data, String key, Date defaultValue) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return mapItemToDate(data, key, df, defaultValue);
    }

    public static Date mapItemToDate(Map data, String key, SimpleDateFormat simpleDateFormat, Date defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return toDate(data.get(key), simpleDateFormat, defaultValue);
    }

    public static long mapItemMoneyTo100IntMoney(Map data, String key) {
        return mapItemMoneyTo100IntMoney(data, key, 0);
    }

    public static long mapItemMoneyTo100IntMoney(Map data, String key, long defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return moneyStringTo100IntMoney(data.get(key), defaultValue);
    }

    //</editor-fold>

    //<editor-fold desc="Base Value">
    public static String dateToString(long time) {
        Date date = new Date(time);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String format = f.format(new Date(time));
        return format;
    }

    public static long stringToLongDate(String timeString) {
        return 0L;
    }

    public static Date toDate(Object value) {
        return toDate(value, null);
    }

    public static Date toDate(Object value, Date defaultValue) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return toDate(value, df, defaultValue);
    }

    public static Date toDate(Object value, SimpleDateFormat simpleDateFormat, Date defaultValue) {
        String s = toString(value);
        if (s.length() == 0) {
            return defaultValue;
        }
        try {
            Date date = simpleDateFormat.parse(s);
            return date;
        } catch (ParseException e) {
            return defaultValue;
        }
    }

    public static String toString(Object value) {
        return toString(value, "");
    }

    public static String toString(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static int toInt(Object value) {
        return toInt(value, 0);
    }

    public static int toInt(Object value, int defaultValue) {
        String s = toString(value, "");
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        if (s.indexOf("E") > 0) {
            Long aLong = scienceToLong(s);
            return aLong.intValue();
        }
        if (s.indexOf("e") > 0) {
            Long aLong = scienceToLong(s);
            return aLong.intValue();
        }
        return Integer.valueOf(s);
    }

    public static boolean toBool(Object value) {
        return toBool(value, false);
    }

    public static boolean toBool(Object value, boolean defaultValue) {
        String s = toString(value, "");
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static long toLong(Object value) {
        return toLong(value, 0);
    }

    public static long toLong(Object value, long defaultValue) {
        String s = toString(value, "");
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        if (s.indexOf("E") > 0) {
            return scienceToLong(s);
        }
        if (s.indexOf("e") > 0) {
            return scienceToLong(s);
        }
        return Long.valueOf(s);
    }

    public static double toDouble(Object data) {
        return toDouble(data, 0);
    }

    public static double toDouble(Object data, double defaultValue) {
        String value = toString(data, "");
        if (value == "")
            return defaultValue;
        return Double.valueOf(value);
    }

    public static short toShort(Object data) {
        short val = 0;
        return toShort(data, val);
    }

    public static short toShort(Object data, short defaultValue) {
        String value = toString(data, "");
        if (value == "")
            return defaultValue;
        value=value.replace(".0", "");
        return Short.valueOf(value);
    }

    public static boolean toBoolean(Object data) {
        return toBoolean(data, false);
    }

    public static boolean toBoolean(Object data, boolean defaultValue) {
        String value = toString(data, "");
        if (value == "")
            return defaultValue;
        return Boolean.valueOf(value);
    }


    public static char toChar(Object data) {
        return toChar(data, '0');
    }

    public static char toChar(Object data, char defaultValue) {
        String value = toString(data, "");
        if (value == "")
            return defaultValue;
        return value.charAt(0);
    }

    public static byte toByte(Object data) {
        byte val = 0;
        return toByte(data, val);
    }

    public static byte toByte(Object data, byte defaultValue) {
        String value = toString(data, "");
        if (value == "")
            return defaultValue;
        return Byte.parseByte(value);
    }
    public static  <E extends Enum<E>> E toEnum(Object data, Class<E> eClass, E defaultValue){
        String value = toString(data, "");
        if (value == "")
            return defaultValue;
        return E.valueOf(eClass,value);
    }
    public static  <E extends Enum<E>> E toEnum(Object data, Class<E> eClass){
        return toEnum(data,eClass,null);
    }

    /**
     * 科学计数法形式字符串转Long
     *
     * @param str ss
     * @return ss
     */
    public static Long scienceToLong(String str) {
        BigDecimal demical = new BigDecimal(str);
//        str = str.replaceAll(",", "");
//        Long aLong = Long.parseLong(str);
        return demical.longValue();
    }

    public static BigDecimal toBigDecimal(Object value) {
        double v = toDouble(value, 0L);
        return BigDecimal.valueOf(v);
    }


    public static long moneyStringTo100IntMoney(Object value) {
        return moneyStringTo100IntMoney(value, 0);
    }

    public static long moneyStringTo100IntMoney(Object value, long defaultValue) {
        BigDecimal v = toBigDecimal(value);
        BigDecimal b = BigDecimal.valueOf(100);
        v = v.multiply(b);
        try {
            return v.longValue();
        } catch (Exception e) {
            return defaultValue;
        }
    }
    public static String money100IntToStringMoney(Object value) {
        return money100IntToStringMoney(value, "0.00");
    }

    public static String money100IntToStringMoney(Object value, String defaultValue) {
        BigDecimal v = toBigDecimal(value);
        BigDecimal b = BigDecimal.valueOf(100);
        v = v.divide(b);
        b =v.setScale(2, RoundingMode.HALF_UP);//保留两位小数
        try {
            return "¥"+b+"";
        } catch (Exception e) {
            return defaultValue;
        }
    }


    //</editor-fold>

    public static String filterEmoji(String nick_name) {
        //nick_name 所获取的用户昵称
        if (nick_name == null) {
            return nick_name;
        }
        Pattern emoji = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\ud83e\udc00-\ud83e\udfff]|[\u2600-\u27ff]",
                Pattern.UNICODE_CASE | Pattern.CASE_INSENSITIVE);
        Matcher emojiMatcher = emoji.matcher(nick_name);
        if (emojiMatcher.find()) {
            //将所获取的表情转换为*
            nick_name = emojiMatcher.replaceAll("*");
            return nick_name;
        }
        return nick_name;
    }

    public static boolean isNumeric(String str){
        for (int i = str.length();--i>=0;){
            if (!Character.isDigit(str.charAt(i))){
                return false;
            }
        }
        return true;
    }
    public static boolean isEmail(String string) {
        if (string == null)
            return false;
        String regEx1 = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        Pattern p;
        Matcher m;
        p = Pattern.compile(regEx1);
        m = p.matcher(string);
        if (m.matches())
            return true;
        else
            return false;
    }
    /**
     * 判断是否为手机号
     * @param phone 手机号
     * @return 响应数据
     */
    public static boolean isMobile(String phone) {
        String regex = "^1\\d{10}$";
        // 移动： 139 138 137 136 135 134 147 150 151 152 157 158 159 182 183 184
        // 187 188
        // 联通： 130 131 132 155 156 185 186 145
        // 电信： 133 153 180 181 189
        boolean flag = false;
        try {
            phone = phone.replaceAll(" ", "");
            if (StringUtils.isEmpty(phone)) {
                return flag;
            }
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(phone);
            flag = matcher.matches();
        } catch (Exception e) {
            return Boolean.FALSE;
        }
        return flag;
    }


    /**
     * 是否为大写命名
     */
    private static final Pattern CAPITAL_MODE = Pattern.compile("^[0-9A-Z/_]+$");
    /**
     * 是否为大写命名
     *
     * @param word 待判断字符串
     * @return ignore
     */
    public static boolean isCapitalMode(String word) {
        return null != word && CAPITAL_MODE.matcher(word).matches();
    }


    /**
     * 是否为驼峰下划线混合命名
     *
     * @param word 待判断字符串
     * @return ignore
     */
    public static boolean isMixedMode(String word) {
        return matches(".*[A-Z]+.*", word) && matches(".*[/_]+.*", word);
    }


    /**
     * 首字母转换小写
     *
     * @param param 需要转换的字符串
     * @return 转换好的字符串
     */
    public static String firstToLowerCase(String param) {
        if (isBlank(param)) {
            return "";
        }
        return param.substring(0, 1).toLowerCase() + param.substring(1);
    }

    /**
     * @return Returns a capacity that is sufficient to keep the map from being resized as
     * long as it grows no larger than expectedSize and the load factor is >= its
     * default (0.75).
     *
     * @see com.google.common.collect.Maps#capacity(int)
     * @since 3.4.0
     */
    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            if (expectedSize < 0) {
                throw new IllegalArgumentException("expectedSize cannot be negative but was: " + expectedSize);
            }
            return expectedSize + 1;
        }
        if (expectedSize < MAX_POWER_OF_TWO) {
            // This is the calculation used in JDK8 to resize when a putAll
            // happens; it seems to be the most conservative calculation we
            // can make.  0.75 is the default load factor.
            return (int) ((float) expectedSize / 0.75F + 1.0F);
        }
        return Integer.MAX_VALUE; // any large value
    }
    private static final int MAX_POWER_OF_TWO = 1 << (Integer.SIZE - 2);


    /**
     * 根据预期大小创建HashMap.
     *
     * @param expectedSize 预期大小
     * @param <K>          K
     * @param <V>          V
     * @return HashMap
     * @since 3.4.0
     */
    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap<>(capacity(expectedSize));
    }


    /**
     * 正则表达式匹配
     *
     * @param regex 正则表达式字符串
     * @param input 要匹配的字符串
     * @return 如果 input 符合 regex 正则表达式格式, 返回true, 否则返回 false;
     */
    public static boolean matches(String regex, String input) {
        if (null == regex || null == input) {
            return false;
        }
        return Pattern.matches(regex, input);
    }

    public static String firstCapitalLetterName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return  name;
    }
    public static String firstLowercaseLetterName(String name) {
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return  name;
    }

}
