package cn.net.vidyo.framework.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

/**
 * ssss
 */
public class IdUtil {

    public static String buildYYYYMMDD(){
        StringBuilder builder=new StringBuilder();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        builder.append(f.format(new Date()));
        return builder.toString();
    }
    public static String buildYYYYMMDDHHMMSS(){
        StringBuilder builder=new StringBuilder();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHHmmss");
        builder.append(f.format(new Date()));
        return builder.toString();
    }
    public static String buildYYYYMMDDHHMMSSSSS(){
        StringBuilder builder=new StringBuilder();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        builder.append(f.format(new Date()));
        return builder.toString();
    }

    public static String buildExtension(int style,int id){
        long  ids=id+1000000000;
        return String.valueOf(style)+ids;
    }
    public static String buildClassKey(int roomId){
        return buildExtension(1,roomId);
    }
    public static String buildUserKey(int userId){
        return buildExtension(2,userId);
    }
    public static String buildUsername(int userId){
        long  id=userId+1000000000;
        return "u"+id;
    }
    public static  String buildDateKey(){
        // 将时间对象格式化为字符串
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return format.format(now);
    }
    public static  String buildGuid(){
        return UUID.randomUUID().toString();
    }
    public static  String buildKey(){
        return buildKey("");
    }
    public static  String buildKey(String prest){
        return prest+buildGuid().replace("-","");
    }
    /**
     * 方法1：生成随机数字和字母组合
     * @param length d
     * @param preString ss
     * @return d
     */
    public static String buildNumKey(String preString,int length) {
        Random random = new Random();
        StringBuilder valSb = new StringBuilder();
        String charStr = "0123456789";
        int charLength = charStr.length();
        for (int i = 0; i < length; i++) {
            int index = random.nextInt(charLength);
            valSb.append(charStr.charAt(index));
        }
        return preString+ valSb;
    }
    public static String buildNumKey(int length) {
        return buildNumKey("",length);
    }
    /**
     * 方法1：生成随机数字和字母组合
     * @param length d
     * @return  d
     */
    public static String getCharAndNum(int length) {
        Random random = new Random();
        StringBuilder valSb = new StringBuilder();
        String charStr = "0123456789abcdefghijklmnopqrstuvwxyz";
        int charLength = charStr.length();

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(charLength);
            valSb.append(charStr.charAt(index));
        }
        return valSb.toString();
    }

    /**
     * 方法2：生成随机数字和字母组合
     * @param length  长度
     * @return dd
     */
    public static String getCharAndNum2(int length) {
        StringBuilder valSb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            String charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num"; // 输出字母还是数字
            if ("char".equalsIgnoreCase(charOrNum)) {
                // 字符串
                int choice = random.nextInt(2) % 2 == 0 ? 65 : 97;  // 取得大写字母还是小写字母
                valSb.append((char) (choice + random.nextInt(26)));
            } else if ("num".equalsIgnoreCase(charOrNum)) {
                // 数字
                valSb.append(random.nextInt(10));
            }
        }
        return valSb.toString();
    }

    /**
     * 方法3：生成随机数字和字母组合
     * @param length ss
     * @return  s
     */
    public static String getCharAndNumr3(int length) {
        StringBuilder valSb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            String charOrNum = Math.round(Math.random()) % 2 == 0 ? "char" : "num"; // 输出字母还是数字
            if ("char".equalsIgnoreCase(charOrNum)) {
                // 字符串
                int choice = Math.round(Math.random()) % 2 == 0 ? 65 : 97;  // 取得大写字母还是小写字母
                valSb.append((char) (choice + Math.round(Math.random()*25)));
            } else if ("num".equalsIgnoreCase(charOrNum)) {
                // 数字
                valSb.append(Math.round(Math.random() * 9));
            }
        }
        return valSb.toString();
    }

    /**
     *字母
     * @param count d
     * @return 返回信息
     */
    public static String buildLetterIdKey(int count){
        StringBuilder sb = new StringBuilder();
        for(int index=0;index<count;index++){
            sb.append((char) ((int) 'a' + Math.random() * 26));
        }
        return sb.toString();
    }

    /**
     *数字
     * @param count d
     * @return 返回信息
     */
    public static String buildNumberIdKey(int count){
        StringBuilder sb = new StringBuilder();
        for(int index=0;index<count;index++){
            sb.append((char) ((int) '0' + Math.random() * 10));
        }
        return sb.toString();
    }

    /**
     * 字母和数字混合
     * @param count d
     * @return 返回信息
     */
    public static String buildLetterNumberIdKey(int count){
        return buildLetterNumberIdKey(count,true);
    }
    /**
     * 字母和数字混合
     * @param count d
     * @param includeUpper  s
     * @return 返回信息
     */
    public static String buildLetterNumberIdKey(int count,boolean includeUpper){
        Random random=new Random(new Date().getTime());
        StringBuilder sb = new StringBuilder();
        for(int index=0;index<count;index++){
            int value=random.nextInt(3);
            switch (value){
                case 0:
                    sb.append((char) ((int) '0' + Math.random() * 10));
                    break;
                case 1:
                    sb.append((char) ((int) 'a' + Math.random() * 26));
                    break;
                case 2:
                    if(includeUpper){
                        sb.append((char) ((int) 'A' + Math.random() * 26));
                    }else{
                        sb.append((char) ((int) 'a' + Math.random() * 26));
                    }
                    break;
            }
        }
        return sb.toString();
    }



    /**
     *
     * @param count d d
     * @return 返回信息
     */
    public static String buildDateTimeLetterIdKey(int count){
        StringBuilder sb = new StringBuilder();
        sb.append(buildDateTime_yyyyMMddhhmmssSSS(new Date()));
        sb.append(buildLetterIdKey(count));
        return sb.toString();
    }

    /**
     *
     * @param count ddd
     * @return 返回信息
     */
    public static String buildDateLetterIdKey(int count){
        StringBuilder sb = new StringBuilder();
        sb.append(buildDate_yyyyMMdd(new Date()));
        sb.append(buildLetterIdKey(count));
        return sb.toString();
    }

    /**
     *
     * @param count dd
     * @return 返回信息
     */
    public static String buildTimeLetterIdKey(int count){
        StringBuilder sb = new StringBuilder();
        sb.append(buildTime_hhmmssSSS(new Date()));
        sb.append(buildLetterIdKey(count));
        return sb.toString();
    }

    /**
     *
     * @param date ss
     * @return 返回信息
     */
    public static String buildDate_yyyyMMdd(Date date){
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sb.append(sdf.format(date));
        return sb.toString();
    }

    /**
     *
     * @param date dd
     * @return 返回信息
     */
    public static String buildTime_hhmmssSSS(Date date){
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("hhmmssSSS");
        sb.append(sdf.format(date));
        return sb.toString();
    }
    /**
     *
     * @param date sd
     * @return 返回信息
     */
    public static String buildDateTime_yyyyMMddhhmmssSSS(Date date){
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        sb.append(sdf.format(date));
        return sb.toString();
    }

    /**
     *字母
     * @param count dd
     * @return 返回信息
     */
    public static String buildLetter(int count){
        StringBuilder sb = new StringBuilder();
        for(int index=0;index<count;index++){
            sb.append((char) ((int) 'a' + Math.random() * 26));
        }
        return sb.toString();
    }

    /**
     *数字
     * @param count dd
     * @return 返回信息
     */
    public static String buildNumber(int count){
        StringBuilder sb = new StringBuilder();
        for(int index=0;index<count;index++){
            sb.append((char) ((int) '0' + Math.random() * 10));
        }
        return sb.toString();
    }

    static int[] letterNumberList=new int[]{0,1,2,3,4,5,6,7,8,9,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122};
    /**
     * 字母和数字混合
     * @param count  ddd
     * @return 返回信息
     */
    public static String buildLetterNumber(int count){
        return buildLetterNumber(count,true);
    }
    /**
     * 字母和数字混合
     * @param count dd
     * @param upperCase  dd
     * @return 返回信息
     */
    public static String buildLetterNumber(int count, boolean upperCase){
        Random random=new Random(new Date().getTime());
        StringBuilder sb = new StringBuilder();
        for(int index=0;index<count;index++){
            int value=random.nextInt(3);
            switch (value){
                case 0:
                    sb.append((char) ((int) 'a' + Math.random() * 26));
                    break;
                case 1:
                    sb.append((char) ((int) 'a' + Math.random() * 26));
                    break;
                case 2:
                    if(upperCase) {
                        sb.append((char) ((int) 'A' + Math.random() * 26));
                    }else{
                        sb.append((char) ((int) 'a' + Math.random() * 26));
                    }
                    break;
            }
        }
        return sb.toString();
    }
}
