package cn.net.vidyo.framework.common.util;

import org.springframework.cglib.beans.BeanMap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapUtil {

    /**
     * ss
     * @param <K>  ss
     * @param <V>  ss
     * @return ss
     */
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap<>(100);
    }

    /**
     * dds
     * @param k d
     * @param v d
     * @param <K> d
     * @param <V> d
     * @return d
     */
    public static <K, V> HashMap<K, V> newHashMap(K k, V v) {
        HashMap<K, V> map = new HashMap<>(100);
        map.put(k, v);
        return map;
    }

    /**
     * sss
     * @param k fd
     * @param v d
     * @param extraKeyValues d
     * @param <K> d
     * @param <V> d
     * @return d
     */
    @SuppressWarnings("unchecked")
    public static <K, V> HashMap<K, V> newHashMap(K k, V v,
                                                  Object... extraKeyValues) {
        if (extraKeyValues.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap<K, V> map = new HashMap<>(100);
        map.put(k, v);
        for (int i = 0; i < extraKeyValues.length; i += 2) {
            k = (K) extraKeyValues[i];
            v = (V) extraKeyValues[i + 1];
            map.put(k, v);
        }
        return map;
    }


    /**
     * 将对象装换为map
     * @param bean d
     * @param <T> ss
     * @return dd
     */
    public static <T> Map<String, Object> beanToMap(T bean) {
        Map<String, Object> map = newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key+"", beanMap.get(key));
            }
        }
        return map;
    }

    /**
     * 将map装换为javabean对象
     * @param map dd
     * @param bean dd
     * @param <T>  dd
     * @return  d
     */
    public static <T> T mapToBean(Map<String, Object> map,T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    /**
     * 转换
     * @param objList  d
     * @param <T>  d
     * @return d
     */
    public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
        List<Map<String, Object>> list = ListUtil.newArrayList();
        if (objList != null && objList.size() > 0) {
            Map<String, Object> map ;
            T bean;
            for (T t : objList) {
                bean = t;
                map = beanToMap(bean);
                list.add(map);
            }
        }
        return list;
    }

    /**
     * ss
      * @param maps s
     * @param clazz s
     * @param <T> s
     * @return s
     * @throws InstantiationException s
     * @throws IllegalAccessException s
     */
    public static <T> List<T> mapsToObjects(List<Map<String, Object>> maps,Class<T> clazz) throws InstantiationException, IllegalAccessException {
        List<T> list = ListUtil.newArrayList();
        if (maps != null && maps.size() > 0) {
            Map<String, Object> map;
            T bean;
            for (Map<String, Object> stringObjectMap : maps) {
                map = stringObjectMap;
                bean = clazz.newInstance();
                mapToBean(map, bean);
                list.add(bean);
            }
        }
        return list;
    }
}
