/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.common.util;

import cn.net.vidyo.framework.common.util.ListUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.beans.BeanMap;

public class MapUtil {
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap(100);
    }

    public static <K, V> HashMap<K, V> newHashMap(K k, V v) {
        HashMap<K, V> map = new HashMap<K, V>(100);
        map.put(k, v);
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(K k, V v, Object ... extraKeyValues) {
        if (extraKeyValues.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap<K, V> map = new HashMap<K, V>(100);
        map.put(k, v);
        for (int i = 0; i < extraKeyValues.length; i += 2) {
            k = extraKeyValues[i];
            v = extraKeyValues[i + 1];
            map.put(k, v);
        }
        return map;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap<String, Object> map = MapUtil.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
        List<Map<String, Object>> list = ListUtil.newArrayList(new Map[0]);
        if (objList != null && objList.size() > 0) {
            Iterator<T> iterator = objList.iterator();
            while (iterator.hasNext()) {
                T t;
                T bean = t = iterator.next();
                Map<String, Object> map = MapUtil.beanToMap(bean);
                list.add(map);
            }
        }
        return list;
    }

    public static <T> List<T> mapsToObjects(List<Map<String, Object>> maps, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        List<Object> list = ListUtil.newArrayList(new Object[0]);
        if (maps != null && maps.size() > 0) {
            Iterator<Map<String, Object>> iterator = maps.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> stringObjectMap;
                Map<String, Object> map = stringObjectMap = iterator.next();
                T bean = clazz.newInstance();
                MapUtil.mapToBean(map, bean);
                list.add(bean);
            }
        }
        return list;
    }
}

