/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.common.util;

import cn.net.vidyo.framework.common.util.ListUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final char SEPARATOR = '_';
    private static final String CHARSET_NAME = "UTF-8";

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0 || "null".equalsIgnoreCase(str);
    }

    public static String realStr(String str) {
        return StringUtils.isEmpty(str) ? "" : str;
    }

    public static boolean isEmptyObject(Object obj) {
        if (null == obj) {
            return true;
        }
        return StringUtils.isEmpty(obj.toString());
    }

    public static boolean isNullEmpty(String str) {
        return null == str || "".equals(str) || "null".equalsIgnoreCase(str) || "undefined".equalsIgnoreCase(str);
    }

    public static boolean isNullorEmpty(Map map) {
        return null == map || map.size() == 0;
    }

    public static byte[] getBytes(String str) {
        if (str != null) {
            try {
                return str.getBytes(CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static boolean inString(String str, String ... strs) {
        if (str != null) {
            for (String s : strs) {
                if (!str.equals(StringUtils.trim((String)s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String replaceHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        String regEx = "<.+?>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(html);
        return m.replaceAll("");
    }

    public static String replaceMobileHtml(String html) {
        if (html == null) {
            return "";
        }
        return html.replaceAll("<([a-z]+?)\\s+?.*?>", "<$1>");
    }

    public static String abbr(String str, int length) {
        if (str == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            int currentLength = 0;
            for (char c : StringUtils.replaceHtml(StringEscapeUtils.unescapeHtml4((String)str)).toCharArray()) {
                if ((currentLength += String.valueOf(c).getBytes("GBK").length) > length - 3) {
                    sb.append("...");
                    break;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String abbr2(String param, int length) {
        if (param == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int n = 0;
        boolean isCode = false;
        boolean isHTML = false;
        for (int i = 0; i < param.length(); ++i) {
            char temp = param.charAt(i);
            if (temp == '<') {
                isCode = true;
            } else if (temp == '&') {
                isHTML = true;
            } else if (temp == '>' && isCode) {
                --n;
                isCode = false;
            } else if (temp == ';' && isHTML) {
                isHTML = false;
            }
            try {
                if (!isCode && !isHTML) {
                    n += String.valueOf(temp).getBytes("GBK").length;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (n > length - 3) {
                result.append("...");
                break;
            }
            result.append(temp);
        }
        String temp_result = result.toString().replaceAll("(>)[^<>]*(<?)", "$1$2");
        temp_result = temp_result.replaceAll("</?(AREA|BASE|BASEFONT|BODY|BR|COL|COLGROUP|DD|DT|FRAME|HEAD|HR|HTML|IMG|INPUT|ISINDEX|LI|LINK|META|OPTION|P|PARAM|TBODY|TD|TFOOT|TH|THEAD|TR|area|base|basefont|body|br|col|colgroup|dd|dt|frame|head|hr|html|img|input|isindex|li|link|meta|option|p|param|tbody|td|tfoot|th|thead|tr)[^<>]*/?>", "");
        temp_result = temp_result.replaceAll("<([a-zA-Z]+)[^<>]*>(.*?)</\\1>", "$2");
        Pattern p = Pattern.compile("<([a-zA-Z]+)[^<>]*>");
        Matcher m = p.matcher(temp_result);
        List<String> endHTML = ListUtil.newArrayList(new String[0]);
        while (m.find()) {
            endHTML.add(m.group(1));
        }
        for (int i = endHTML.size() - 1; i >= 0; --i) {
            result.append("</");
            result.append(endHTML.get(i));
            result.append(">");
        }
        return result.toString();
    }

    public static Double toDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(StringUtils.trim((String)val.toString()));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static Float toFloat(Object val) {
        return Float.valueOf(StringUtils.toDouble(val).floatValue());
    }

    public static Long toLong(Object val) {
        return StringUtils.toDouble(val).longValue();
    }

    public static Integer toInteger(Object val) {
        return StringUtils.toLong(val).intValue();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = StringUtils.toCamelCase(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String toUnderScoreCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i > 0 && Character.isUpperCase(c)) {
                if (!upperCase || !nextUpperCase) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static void setValueIfNotBlank(String target, String source) {
        if (StringUtils.isNotBlank((CharSequence)target)) {
            target = source;
        }
    }

    public static String jsGetVal(String objectString) {
        String[] vals;
        StringBuilder result = new StringBuilder();
        StringBuilder val = new StringBuilder();
        for (String s : vals = StringUtils.split((String)objectString, (String)".")) {
            val.append(".").append(s);
            result.append("!").append(val.substring(1)).append("?'':");
        }
        result.append(val.substring(1));
        return result.toString();
    }

    public static boolean stringFilter(String str) {
        String regEx = "(\\w*(/){0,1})*\\w*.{1}[a-zA-Z]*";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static String firstCharacterToUpperCase(String fildeName) {
        byte[] items = fildeName.getBytes();
        if (Character.isUpperCase(items[0])) {
            return fildeName;
        }
        items[0] = (byte)((char)items[0] - 97 + 65);
        return new String(items);
    }

    public static boolean stroneContainsStrtwo(String strOne, String strTwo, String strtwoSeparator) {
        String[] strTwoArr;
        if (StringUtils.isEmpty(strOne)) {
            return false;
        }
        if (StringUtils.isEmpty(strTwo)) {
            return false;
        }
        if (StringUtils.isEmpty(strtwoSeparator)) {
            return strOne.contains(strTwo);
        }
        for (String s : strTwoArr = strTwo.split(strtwoSeparator)) {
            if (!strOne.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static String subStringBySeparator(String resultStr, String separator) {
        if (StringUtils.isEmpty(resultStr)) {
            return "";
        }
        if (resultStr.contains(separator)) {
            return resultStr.replace(separator, "");
        }
        return resultStr;
    }

    public static String get32UUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String underscoreName(String name) {
        StringBuilder result = new StringBuilder();
        if (name != null && name.length() > 0) {
            char az = name.charAt(0);
            if (az >= 'A' && az <= 'Z') {
                return name;
            }
            result.append(name.charAt(0));
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals(s.toUpperCase())) {
                    result.append("_");
                    result.append(s.toLowerCase());
                    continue;
                }
                result.append(s);
            }
        }
        return result.toString();
    }

    public static String camelName(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            if (result.length() == 0) {
                result.append(camel.toLowerCase());
                continue;
            }
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String getRandom(int num) {
        Random r = new Random();
        StringBuilder rand = new StringBuilder();
        for (int i = 1; i <= num; ++i) {
            rand.append(r.nextInt(10));
        }
        return rand.toString();
    }
}

