/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;

public class PropertyUtils {
    static char[] a_z = "abcdefghijklmnopqrstwvuxyz".toCharArray();
    static char[] A_Z = "abcdefghijklmnopqrstwvuxyz".toUpperCase().toCharArray();

    public static String columnToProperty(String column) {
        if (column == null || column.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder(column.length());
        int length = column.length();
        for (int j = 0; j < length; ++j) {
            if (column.charAt(j) == '_') {
                int i = j;
                char c = column.charAt(i);
                for (int k = 0; k < a_z.length; ++k) {
                    if (a_z[k] != c) continue;
                    c = A_Z[k];
                    break;
                }
                sb.append(c);
                continue;
            }
            sb.append(column.charAt(j));
        }
        return sb.toString();
    }

    public static void copyProperties(Object sourceObject, Object targetObject) {
        PropertyUtils.copyProperties(sourceObject, targetObject, false);
    }

    public static void copyProperties(Object sourceObject, Object targetObject, boolean copyNullProperty) {
        Field[] declaredFields;
        if (sourceObject == null) {
            return;
        }
        if (targetObject == null) {
            return;
        }
        Class<?> sclassType = sourceObject.getClass();
        Class<?> tclassType = targetObject.getClass();
        for (Field filed : declaredFields = sclassType.getDeclaredFields()) {
            Object value;
            Method setMethod;
            Method getMethod;
            if (filed.getName().indexOf("$") > 0) continue;
            String firstLetter = filed.getName().substring(0, 1).toUpperCase();
            String getMethodName = "get" + firstLetter + filed.getName().substring(1);
            String setMethodName = "set" + firstLetter + filed.getName().substring(1);
            try {
                getMethod = sclassType.getMethod(getMethodName, new Class[0]);
                setMethod = tclassType.getMethod(setMethodName, filed.getType());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if (getMethod == null || setMethod == null) continue;
            try {
                value = getMethod.invoke(sourceObject, new Object[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (value == null && !copyNullProperty) continue;
            try {
                setMethod.invoke(targetObject, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> T getPropertyValue(Object instance, String field) {
        BeanWrapperImpl oBeanWrapper = new BeanWrapperImpl(instance);
        Object value = oBeanWrapper.getPropertyValue(field);
        return (T)value;
    }

    public static void setPropertyValue(Object instance, String field, Object value) {
        BeanWrapperImpl oBeanWrapper = new BeanWrapperImpl(instance);
        oBeanWrapper.setPropertyValue(field, value);
    }

    public static void addPropertyValue(Object instance, String field, Object delta) {
        PropertyUtils.addPropertyMaxValue(instance, field, delta, null);
    }

    public static void addPropertyMaxValue(Object instance, String field, Object maxValue) {
        PropertyUtils.addPropertyMaxValue(instance, field, 1, maxValue);
    }

    public static void addPropertyMaxValue(Object instance, String field, Object delta, Object maxValue) {
        PropertyUtils.increasePropertyMinMaxValue(instance, field, delta, null, maxValue);
    }

    public static void addPropertyValues(Object instance, String ... fields) {
        PropertyUtils.addPropertyValues(instance, 1, fields);
    }

    public static void addPropertyValues(Object instance, Object delta, String ... fields) {
        PropertyUtils.addPropertyMaxValues(instance, delta, null, fields);
    }

    public static void addPropertyMaxValues(Object instance, Object maxValue, String ... fields) {
        PropertyUtils.addPropertyMaxValues(instance, (Object)1, maxValue, fields);
    }

    public static void addPropertyMaxValues(Object instance, Object delta, Object maxValue, String ... fields) {
        PropertyUtils.increasePropertyMinMaxValues(instance, delta, null, maxValue, fields);
    }

    public static void subPropertyValue(Object instance, String field, Object delta) {
        PropertyUtils.subPropertyMinValue(instance, field, delta, null);
    }

    public static void subPropertyMinValue(Object instance, String field, Object minValue) {
        PropertyUtils.subPropertyMinValue(instance, field, -1, minValue);
    }

    public static void subPropertyMinValue(Object instance, String field, Object delta, Object minValue) {
        PropertyUtils.increasePropertyMinMaxValue(instance, field, delta, minValue, null);
    }

    public static void subPropertyValues(Object instance, Object delta, String ... fields) {
        PropertyUtils.subPropertyMinValues(instance, delta, 0, fields);
    }

    public static void subPropertyMaxValues(Object instance, Object minValue, String ... fields) {
        PropertyUtils.subPropertyMinValues(instance, -1, minValue, fields);
    }

    public static void subPropertyValues(Object instance, String ... fields) {
        PropertyUtils.subPropertyMinValues(instance, -1, 0, fields);
    }

    public static void subPropertyMinValues(Object instance, Object delta, Object minValue, String ... fields) {
        PropertyUtils.increasePropertyMinMaxValues(instance, delta, minValue, null, fields);
    }

    public static <T> void addMutiModelPropertyValue(List<T> instances, String field, Object delta) {
        PropertyUtils.addMutiModelPropertyMaxValue(instances, field, delta, null);
    }

    public static <T> void addMutiModelPropertyMaxValue(List<T> instances, String field, Object maxValue) {
        PropertyUtils.addMutiModelPropertyMaxValue(instances, field, 1, maxValue);
    }

    public static <T> void addMutiModelPropertyMaxValue(List<T> instances, String field, Object delta, Object maxValue) {
        PropertyUtils.increaseMutiModelPropertyMinMaxValue(instances, field, delta, null, maxValue);
    }

    public static <T> void addMutiModelPropertyValues(List<T> instances, String ... fields) {
        PropertyUtils.addMutiModelPropertyValues(instances, null, fields);
    }

    public static <T> void addMutiModelPropertyValues(List<T> instances, Object delta, String ... fields) {
        PropertyUtils.addMutiModelPropertyMaxValues(instances, delta, null, fields);
    }

    public static <T> void addMutiModelPropertyMaxValues(List<T> instances, Object maxValue, String ... fields) {
        PropertyUtils.addMutiModelPropertyMaxValues(instances, (Object)1, maxValue, fields);
    }

    public static <T> void addMutiModelPropertyMaxValues(List<T> instances, Object delta, Object maxValue, String ... fields) {
        PropertyUtils.increaseMutiModelPropertyMinMaxValues(instances, delta, null, maxValue, fields);
    }

    public static <T> void subMutiModelPropertyValue(List<T> instances, String field, Object delta) {
        PropertyUtils.subMutiModelPropertyMinValue(instances, field, delta, 0);
    }

    public static <T> void subMutiModelPropertyMinValue(List<T> instances, String field, Object minValue) {
        PropertyUtils.subMutiModelPropertyMinValue(instances, field, 1, minValue);
    }

    public static <T> void subMutiModelPropertyMinValue(List<T> instances, String field, Object delta, Object minValue) {
        PropertyUtils.increaseMutiModelPropertyMinMaxValues(instances, field, delta, minValue, new String[0]);
    }

    public static <T> void subMutiModelPropertyValues(List<T> instances, String ... fields) {
        PropertyUtils.subMutiModelPropertyMinValues(instances, (Object)-1, 0, fields);
    }

    public static <T> void subMutiModelPropertyValues(List<T> instances, Object delta, String ... fields) {
        PropertyUtils.subMutiModelPropertyMinValues(instances, delta, 0, fields);
    }

    public static <T> void subMutiModelPropertyMinValues(List<T> instances, Object minValue, String ... fields) {
        PropertyUtils.subMutiModelPropertyMinValues(instances, (Object)-1, minValue, fields);
    }

    public static <T> void subMutiModelPropertyMinValues(List<T> instances, Object delta, Object minValue, String ... fields) {
        PropertyUtils.increaseMutiModelPropertyMinMaxValues(instances, delta, minValue, null, fields);
    }

    public static void increasePropertyMinMaxValue(Object instance, String field, Object delta, Object minValue, Object maxValue) {
        Object value = PropertyUtils.getPropertyValue(instance, field);
        if (value == null) {
            return;
        }
        Object newValue = value;
        if (value.getClass().isAssignableFrom(Integer.class)) {
            newValue = (Integer)value + (Integer)delta;
            if (minValue != null && (Integer)minValue > (Integer)newValue) {
                newValue = minValue;
            }
            if (maxValue != null && (Integer)maxValue < (Integer)newValue) {
                newValue = maxValue;
            }
        }
        if (value.getClass().isAssignableFrom(Long.class)) {
            newValue = (Long)value + (Long)delta;
            if (minValue != null && (Long)minValue > (Long)newValue) {
                newValue = minValue;
            }
            if (maxValue != null && (Long)maxValue < (Long)newValue) {
                newValue = maxValue;
            }
        }
        if (value.getClass().isAssignableFrom(Float.class)) {
            newValue = Float.valueOf(((Float)value).floatValue() + ((Float)delta).floatValue());
            if (minValue != null && ((Float)minValue).floatValue() > ((Float)newValue).floatValue()) {
                newValue = minValue;
            }
            if (maxValue != null && ((Float)maxValue).floatValue() < ((Float)newValue).floatValue()) {
                newValue = maxValue;
            }
        }
        if (value.getClass().isAssignableFrom(Double.class)) {
            newValue = (Double)value + (Double)delta;
            if (minValue != null && (Double)minValue > (Double)newValue) {
                newValue = minValue;
            }
            if (maxValue != null && (Double)maxValue < (Double)newValue) {
                newValue = maxValue;
            }
        }
        PropertyUtils.setPropertyValue(instance, field, newValue);
    }

    public static void increasePropertyMinMaxValues(Object instance, Object delta, Object minValue, Object maxValue, String ... fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (String field : fields) {
            PropertyUtils.increasePropertyMinMaxValue(instance, field, delta, minValue, maxValue);
        }
    }

    public static void increasePropertyValue(Object instance, String field, Object delta) {
        PropertyUtils.increasePropertyMinMaxValue(instance, field, delta, null, null);
    }

    public static void increasePropertyValues(Object instance, Object delta, String ... fields) {
        PropertyUtils.increasePropertyMinMaxValues(instance, delta, null, null, fields);
    }

    public static <T> void increaseMutiModelPropertyMinMaxValue(List<T> instances, String field, Object delta, Object minValue, Object maxValue) {
        for (T instance : instances) {
            PropertyUtils.increasePropertyMinMaxValue(instance, field, delta, minValue, maxValue);
        }
    }

    public static <T> void increaseMutiModelPropertyMinMaxValues(List<T> instances, Object delta, Object minValue, Object maxValue, String ... fields) {
        if (instances == null) {
            return;
        }
        for (T instance : instances) {
            PropertyUtils.increasePropertyMinMaxValues(instance, delta, minValue, maxValue, fields);
        }
    }

    public static <T> void increaseMutiModelPropertyValue(List<T> instances, String field, Object delta) {
        PropertyUtils.increaseMutiModelPropertyMinMaxValue(instances, field, delta, 0, null);
    }

    public static <T> void increaseMutiModelPropertyValues(List<T> instances, Object delta, String ... fields) {
        PropertyUtils.increaseMutiModelPropertyMinMaxValues(instances, delta, 0, null, fields);
    }
}

