/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.common.util;

import cn.net.vidyo.framework.common.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    public static final String DEFAILT_DATE_PATTERN = "yyyy-MM-dd";
    private static final SimpleDateFormat wkDateFm = new SimpleDateFormat("EEEE", Locale.CHINA);
    private static final SimpleDateFormat dateFm = new SimpleDateFormat("MM-dd");
    private static final String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static java.util.Date convertStringToDate(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        java.util.Date date = null;
        try {
            date = format.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getDateTimeToString(java.util.Date date) {
        SimpleDateFormat sformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sformat.format(date);
    }

    public static String getDateToString(java.util.Date date) {
        SimpleDateFormat sformat = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        return sformat.format(date);
    }

    public static String getTimeToString(java.util.Date date) {
        SimpleDateFormat sformat = new SimpleDateFormat("HH:mm:ss");
        return sformat.format(date);
    }

    public static String getBetweenDateTimeToString(java.util.Date beginDate, java.util.Date endDate) {
        SimpleDateFormat dformat = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        SimpleDateFormat tformat = new SimpleDateFormat("HH:mm");
        String beginDateString = dformat.format(beginDate);
        String endDateString = dformat.format(endDate);
        String beginTimeString = tformat.format(beginDate);
        String endTimeString = tformat.format(endDate);
        StringBuilder builder = new StringBuilder();
        builder.append(beginDateString);
        if (beginDateString.endsWith(endDateString)) {
            builder.append(" ");
            builder.append(beginTimeString);
            builder.append("-");
            builder.append(endTimeString);
        } else {
            builder.append(" ");
            builder.append(beginTimeString);
            builder.append("-");
            builder.append(endDateString);
            builder.append(" ");
            builder.append(endTimeString);
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getCurDateTime00());
        System.out.println(DateUtil.getCurDateTime24());
    }

    public static Integer getAgeByBirth(java.util.Date birthDay) {
        Integer age = 0;
        if (null == birthDay) {
            return age;
        }
        try {
            Calendar cal = Calendar.getInstance();
            Calendar bir = Calendar.getInstance();
            bir.setTime(birthDay);
            if (cal.before(bir)) {
                return age;
            }
            int yearNow = cal.get(1);
            int monthNow = cal.get(2);
            int dayOfMonthNow = cal.get(5);
            cal.setTime(birthDay);
            int yearBirth = cal.get(1);
            int monthBirth = cal.get(2);
            int dayOfMonthBirth = cal.get(5);
            age = yearNow - yearBirth;
            if (monthNow <= monthBirth) {
                if (monthNow == monthBirth) {
                    if (dayOfMonthNow < dayOfMonthBirth) {
                        Integer n = age;
                        Integer n2 = age = Integer.valueOf(age - 1);
                    }
                } else {
                    Integer n = age;
                    Integer n3 = age = Integer.valueOf(age - 1);
                }
            }
        }
        catch (Exception e) {
            return age;
        }
        return age;
    }

    public static String getDate() {
        return DateUtil.getDate(DEFAILT_DATE_PATTERN);
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((java.util.Date)new java.util.Date(), (String)pattern);
    }

    public static String formatDate(java.util.Date date, Object ... pattern) {
        String formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((java.util.Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((java.util.Date)date, (String)DEFAILT_DATE_PATTERN);
        return formatDate;
    }

    public static String addDateMinut(java.util.Date date, int hour) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, hour);
        date = cal.getTime();
        return format.format(date);
    }

    public static java.util.Date addDateMonth(java.util.Date date, int month) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, month);
        return cal.getTime();
    }

    public static String addDateSecond(java.util.Date date, Integer sec) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, sec);
        date = cal.getTime();
        return format.format(date);
    }

    public static String formatDateTime(java.util.Date date) {
        if (null == date) {
            return "";
        }
        return DateUtil.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String dateTime2Date(java.util.Date date) {
        if (null == date) {
            return "";
        }
        return DateUtil.formatDate(date, DEFAILT_DATE_PATTERN);
    }

    public static String isOnline(java.util.Date time) {
        if (null == time) {
            return "0";
        }
        long loc = time.getTime();
        long now = System.currentTimeMillis();
        long diff = now > loc ? now - loc : 0L;
        int seconds = (int)(diff / 60000L);
        if (seconds > 10 || diff == 0L) {
            return "0";
        }
        return "1";
    }

    public static String getTime() {
        return DateUtil.formatDate(new java.util.Date(), "HH:mm:ss");
    }

    public static String getTimeMillis() {
        return DateUtil.formatDate(new java.util.Date(), "HH:mm:ss:SSS");
    }

    public static String getHourAndMin() {
        return DateUtil.formatDate(new java.util.Date(), "HH:mm");
    }

    public static String getMothAndDay() {
        return DateUtil.formatDate(new java.util.Date(), "MM-dd");
    }

    public static String getDateTime() {
        return DateUtil.formatDate(new java.util.Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getYear() {
        return DateUtil.formatDate(new java.util.Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtil.formatDate(new java.util.Date(), "MM");
    }

    public static String getDay() {
        return DateUtil.formatDate(new java.util.Date(), "dd");
    }

    public static String getWeek() {
        return DateUtil.formatDate(new java.util.Date(), "E");
    }

    public static java.util.Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtil.parseDate((String)str.toString().trim(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(java.util.Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(java.util.Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(java.util.Date date) {
        long t = System.currentTimeMillis() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static double getDistanceOfTwoDate(java.util.Date before, java.util.Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static double getDistanceOfTwoDate(String before, String after) {
        java.util.Date start = DateUtil.parseDate(before);
        java.util.Date end = DateUtil.parseDate(after);
        long beforeTime = start.getTime();
        long afterTime = end.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static String ADD_DATE(int optype, String date, int num) {
        String st_return = "";
        try {
            DateFormat daf_date = DateFormat.getDateInstance(2, Locale.CHINA);
            daf_date.parse(date);
            Calendar calendar = daf_date.getCalendar();
            calendar.add(optype, num);
            int y = calendar.get(1);
            int m = calendar.get(2) + 1;
            int d = calendar.get(5);
            String st_m = m <= 9 ? "0" + m : "" + m;
            String st_d = d <= 9 ? "0" + d : "" + d;
            st_return = y + "-" + st_m + "-" + st_d;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return st_return;
    }

    public static String getCurDate() {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        return sdf.format(date);
    }

    public static String getCurDateTime00() {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        return sdf.format(date);
    }

    public static String getCurDateTime24() {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        return sdf.format(date);
    }

    public static int compareDate(String date1, String date2) {
        String[] date1Array = date1.split("-");
        String[] date2Array = date2.split("-");
        Date date11 = new Date(Integer.parseInt(date1Array[0], 10), Integer.parseInt(date1Array[1], 10), Integer.parseInt(date1Array[2], 10));
        Date date22 = new Date(Integer.parseInt(date2Array[0], 10), Integer.parseInt(date2Array[1], 10), Integer.parseInt(date2Array[2], 10));
        return date11.compareTo(date22);
    }

    public static java.util.Date addMinute(int num, java.util.Date Date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Date2);
        calendar.add(12, num);
        return calendar.getTime();
    }

    public static boolean isTimeBefore(String time) {
        if (time == null) {
            return false;
        }
        try {
            java.util.Date date1 = new java.util.Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            java.util.Date d = df.parse(time);
            return date1.before(d);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isSystemDateBefore(String time) {
        if (time == null) {
            return false;
        }
        try {
            java.util.Date date1 = new java.util.Date();
            SimpleDateFormat df = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
            java.util.Date d = df.parse(time);
            return d.before(date1);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static String isOutOneMouth(java.util.Date day1, java.util.Date day2) {
        if (day1 == null || day2 == null) {
            return "1";
        }
        if (day1.after(day2)) {
            return Math.abs(DateUtil.getDistanceOfTwoDate(day1, day2)) >= 30.0 ? "1" : "2";
        }
        if (day1.before(day2)) {
            return "3";
        }
        return "1";
    }

    public static String isEffective(java.util.Date day1, java.util.Date day2) {
        if (day1 == null || day2 == null) {
            return "1";
        }
        if (day1.after(day2)) {
            return "1";
        }
        if (day1.before(day2) || day1.equals(day2)) {
            return "0";
        }
        return "0";
    }

    public static boolean beforeDate(String date1, String date2) {
        try {
            java.util.Date d1 = DateUtil.convertString2Date(DEFAILT_DATE_PATTERN, date1);
            java.util.Date d2 = DateUtil.convertString2Date(DEFAILT_DATE_PATTERN, date2);
            assert (d1 != null);
            return d1.before(d2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static java.util.Date convertString2Date(String formatString, String targetDate) {
        if (StringUtils.isBlank((CharSequence)targetDate)) {
            return null;
        }
        java.util.Date result = null;
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        try {
            result = format.parse(targetDate);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        return result;
    }

    public static String convertDate2String(java.util.Date targetDate) {
        return DateUtil.convertDate2String(DEFAILT_DATE_PATTERN, targetDate);
    }

    public static String convertDate2String(String formatString, java.util.Date targetDate) {
        if (targetDate == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        String result = format.format(targetDate);
        return result;
    }

    public static String getSystemDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new java.util.Date());
    }

    public static java.util.Date addDay(java.util.Date date, int value) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(6, value);
        return now.getTime();
    }

    public static String getStatetime(int n) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        Calendar c = Calendar.getInstance();
        c.add(5, -n);
        java.util.Date monday = c.getTime();
        return sdf.format(monday);
    }

    public static String getAftertime(java.util.Date date, int n) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, n);
        java.util.Date monday = c.getTime();
        return sdf.format(monday);
    }

    public static String getAftertime(int n) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.add(5, n);
        java.util.Date monday = c.getTime();
        return sdf.format(monday);
    }

    public static String getAfterDate(int n) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        Calendar c = Calendar.getInstance();
        c.add(5, n);
        java.util.Date monday = c.getTime();
        return sdf.format(monday);
    }

    public static String getTimeSubtractDay(String date, int day) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(sdf.parse(date));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        c.add(5, -day);
        java.util.Date monday = c.getTime();
        return sdf.format(monday);
    }

    public static String addMonth(String date, int month) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(sdf.parse(date));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        c.add(2, month);
        java.util.Date monday = c.getTime();
        return sdf.format(monday);
    }

    public static String transformDate(java.util.Date date) {
        java.util.Date cDate = new java.util.Date();
        GregorianCalendar d1 = new GregorianCalendar();
        d1.setTime(date);
        GregorianCalendar d2 = new GregorianCalendar();
        d2.setTime(cDate);
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            do {
                days += ((Calendar)d1).getActualMaximum(6);
                ((Calendar)d1).add(1, 1);
            } while (d1.get(1) != y2);
        }
        String result = days == 0 ? "\u4eca\u5929" : (days == 1 ? "\u6628\u5929" : (days > 1 && days <= 7 ? wkDateFm.format(date) : dateFm.format(date)));
        return result;
    }

    public static java.util.Date getProviousDay(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }

    public static String getDateStr(Long timeMIllis, Object ... format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMIllis);
        return DateUtil.formatDate(calendar.getTime(), format);
    }

    public static java.util.Date getDate(Long timeMIllis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeMIllis);
        return calendar.getTime();
    }

    public static String getDayStr(String date, int day) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(sdf.parse(date));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        calendar.add(6, day);
        return DateUtil.formatDate(calendar.getTime(), DEFAILT_DATE_PATTERN);
    }

    public static String getProviousDay(java.util.Date date, String format) {
        java.util.Date d = DateUtil.getProviousDay(date);
        return DateUtil.formatDate(d, format);
    }

    public static String translateDateToStr(int liveDay) {
        String liveStr = "";
        int liveMonth = liveDay / 30;
        int liveDayNum = liveDay % 30;
        if (liveMonth != 0) {
            liveStr = liveStr + liveMonth + "\u4e2a\u6708";
        }
        if (liveDayNum != 0) {
            liveStr = liveStr + liveDayNum + "\u5929";
        }
        return liveStr;
    }

    public static Integer translateBdRepayDay(String startDate, Integer prepaymentDay) {
        java.util.Date prepayDate;
        int resultDay;
        java.util.Date stDate = DateUtil.parseDate(startDate);
        if (prepaymentDay == 0) {
            prepaymentDay = 1;
        }
        if ((resultDay = (prepayDate = DateUtil.addDay(stDate, -prepaymentDay.intValue())).getDate()) == 29 || resultDay == 30 || resultDay == 31) {
            resultDay = 28;
        }
        return resultDay;
    }

    public static Long getTimeInMillis(java.util.Date date, int day) {
        String dateStr = DateUtil.formatDate(date, DEFAILT_DATE_PATTERN);
        date = DateUtil.parseDate(dateStr);
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(6, day);
        return now.getTimeInMillis();
    }

    public static boolean beforeDateFormat(String date1, String date2) {
        try {
            java.util.Date d1 = DateUtil.convertString2Date("yyyy-MM-dd HH:mm:ss", date1);
            java.util.Date d2 = DateUtil.convertString2Date("yyyy-MM-dd HH:mm:ss", date2);
            assert (d1 != null);
            return d1.before(d2);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static long hourBetweenTwoTime(String date1) throws ParseException {
        if (StringUtils.isEmpty(date1)) {
            return 0L;
        }
        java.util.Date d1 = DateUtil.convertString2Date(date1);
        if (d1 == null) {
            return 0L;
        }
        java.util.Date today = new java.util.Date();
        return (today.getTime() - d1.getTime()) / 3600000L;
    }

    public static long minBetweenTwoTime(String date1) {
        if (StringUtils.isEmpty(date1)) {
            return 0L;
        }
        java.util.Date d1 = DateUtil.convertString2Date("yyyy-MM-dd HH:mm:ss", date1);
        if (d1 == null) {
            return 0L;
        }
        java.util.Date today = new java.util.Date();
        return Math.abs((today.getTime() - d1.getTime()) / 60000L);
    }

    public static boolean compTime(String s1, String s2) {
        try {
            if (s1.contains(":") && s1.contains(":")) {
                String[] array2;
                int total2;
                String[] array1 = s1.split(":");
                int total1 = Integer.parseInt(array1[0]) * 3600 + Integer.parseInt(array1[1]) * 60;
                return total1 - (total2 = Integer.parseInt((array2 = s2.split(":"))[0]) * 3600 + Integer.parseInt(array2[1]) * 60) >= 0;
            }
            System.out.println("\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public static boolean isNow(String str) {
        java.util.Date date = null;
        SimpleDateFormat format = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        try {
            date = format.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        java.util.Date now = new java.util.Date();
        SimpleDateFormat sf = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        String nowDay = sf.format(now);
        String day = sf.format(date);
        return day.equals(nowDay);
    }

    public static boolean compareToDate(String date1, String date2) {
        try {
            java.util.Date dt1 = DateUtil.convertString2Date("yyyy-MM-dd HH:mm:ss", date1);
            java.util.Date dt2 = DateUtil.convertString2Date("yyyy-MM-dd HH:mm:ss", date2);
            assert (dt1 != null);
            return dt1.compareTo(dt2) < 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isTimeMornthanMinutes(String beforeTime, String afterTime, int minute) {
        if (beforeTime == null || afterTime == null) {
            return false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            java.util.Date a = df.parse(afterTime);
            java.util.Date b = df.parse(beforeTime);
            return a.getTime() - b.getTime() - (long)minute * 60L * 1000L > 0L;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isTimeBefore(String beforeTime, String afterTime) {
        if (beforeTime == null || afterTime == null) {
            return false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            java.util.Date a = df.parse(afterTime);
            java.util.Date b = df.parse(beforeTime);
            return b.before(a);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static long minBetweenTwoTime(String date1, String date2) throws ParseException {
        if (StringUtils.isEmpty(date1)) {
            return 0L;
        }
        java.util.Date d1 = DateUtil.convertString2Date(date1);
        if (d1 == null) {
            return 0L;
        }
        java.util.Date d2 = DateUtil.convertString2Date(date2);
        assert (d2 != null);
        return (d2.getTime() - d1.getTime()) / 60000L;
    }

    public static java.util.Date convertString2Date(String targetDate) throws ParseException {
        java.util.Date result;
        if (StringUtils.isBlank((CharSequence)targetDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            result = df.parse(targetDate);
        }
        catch (ParseException pe) {
            throw new ParseException(pe.getMessage(), pe.getErrorOffset());
        }
        return result;
    }

    public static List<String> getBetweenDates(String start, String end) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
            java.util.Date start_date = sdf.parse(start);
            java.util.Date end_date = sdf.parse(end);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start_date);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end_date);
            while (tempStart.before(tempEnd) || tempStart.equals(tempEnd)) {
                result.add(sdf.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean belongTimeRange(java.util.Date nowTime, java.util.Date beginTime, java.util.Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        if (date.after(begin) && date.before(end)) {
            return true;
        }
        return nowTime.compareTo(beginTime) == 0 || nowTime.compareTo(endTime) == 0;
    }

    public static BigDecimal getHourOfTwoDay(String endDtStr, String startDtStr) {
        java.util.Date endDt = DateUtil.parseDate(endDtStr);
        java.util.Date startDt = DateUtil.parseDate(startDtStr);
        long t = endDt.getTime() - startDt.getTime();
        BigDecimal b = new BigDecimal(t);
        BigDecimal b1 = new BigDecimal(3600000);
        return b.divide(b1, 2, RoundingMode.HALF_UP);
    }

    public static List<String> getDays(String startTime, String endTime) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAILT_DATE_PATTERN);
        try {
            java.util.Date start = dateFormat.parse(startTime);
            java.util.Date end = dateFormat.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static long getNowTimeStamp() {
        return System.currentTimeMillis();
    }
}

