package cn.net.vidyo.framework.common.util;

import net.sf.ehcache.hibernate.management.impl.BeanUtils;

import java.util.*;

public class ListUtil {
    /**
     * 碾平集合咯，主要针对集合元素为集合的情况有效果
     *
     * @param list d
     * @param <T> d
     * @return d
     */
    @SuppressWarnings("unchecked")
    public static <T> List<T> flatten(List<?> list) {
        List<T> result = new ArrayList<>();
        for (Object o : list) {
            if (o instanceof List) {
                List<T> subResult = flatten((List<?>) o);
                result.addAll(subResult);
            } else {
                result.add((T) o);
            }
        }
        return result;
    }

    /**
     * 压缩集合，去掉集合中的null记录
     *
     * @param list d
     * @param <T> d
     * @return d
     */
    public static <T> List<T> compact(List<T> list) {
        List<T> result = new ArrayList<>();
        for (T t : list) {
            if (t != null) {
                result.add(t);
            }
        }
        return result;
    }

    /**
     * 提取集合中指定属性值
     *
     * @param list d
     * @param property d
     * @param <T> d
     * @param <R> d
     * @return d
     */
    public static <T, R> List<R> map(List<T> list, String property) {
        List<R> result = new ArrayList<>();
        for (T t : list) {

            try {
                R r = (R) getProperty(t, property);
                result.add(r);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        return result;
    }

    /**
     * 将集合转换为map
     *
     * @param list d
     * @param keyProperty d
     * @param <K> d
     * @param <V> d
     * @return d
     */
    public static <K, V> Map<K, V> toMap(List<V> list, String keyProperty) {
        Map<K, V> map = new HashMap<>(100);
        for (V v : list) {

            try {
                K k = (K) getProperty(v, keyProperty);
                map.put(k, v);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        return map;
    }

    /**
     * 移除与value不想等的值，原集合不发生变化
     *
     * @param list d
     * @param property d
     * @param value d
     * @param <T> d
     * @return d
     */
    public static <T> List<T> filter(List<T> list, String property, Object value) {
        List<T> result = new ArrayList<>();
        for (T t : list) {
            try {
                Object v = getProperty(t, property);
                if ((v == null && value == null) || (v != null && v.equals(value))) {
                    result.add(t);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        return result;
    }

    /**
     * 移除与value相等的值, 原数组不发生变化.
     *
     * @param list d
     * @param value d
     * @param <T> ss
     * @return d
     */
    public static <T> List<T> without(List<T> list, T value) {
        List<T> result = new ArrayList<>();
        for (T t : list) {
            if ((value == null && t == null)
                    || (value != null && value.equals(t))) {
                continue;
            }
            result.add(t);
        }
        return result;
    }

    /**
     * 对集合去重，原集合不发生变化
     *
     * @param input d
     * @param <T> d
     * @return d
     */
    public static <T> List<T> uniq(List<T> input) {
        LinkedHashMap<T, T> map = new LinkedHashMap<>();
        for (T t : input) {
            map.put(t, t);
        }
        return new ArrayList<>(map.values());
    }

    /**
     * 按照给定的集合（keys）进行排序
     *
     * @param input       要排序的集合
     * @param keyProperty 排序的属性
     * @param keys        给定的键值集合
     * @param <K> d
     * @param <T> d
     * @return d
     */
    public static <K, T> List<T> sortBy(List<T> input, String keyProperty,
                                        List<K> keys) {
        if (input.isEmpty()) {
            return new ArrayList<>();
        }

        Map<K, T> map = toMap(input, keyProperty);
        List<T> result = new ArrayList<>();
        for (K k : keys) {
            T t = map.get(k);
            if (t != null) {
                result.add(t);
            }
        }
        return result;
    }

    /**
     * 对集合进行分组
     *
     * @param input d
     * @param keyProperty d
     * @param <K> d
     * @param <V> d
     * @return d
     */
    public static <K, V> Map<K, List<V>> group(List<V> input, String keyProperty) {
        Map<K, List<V>> result = new HashMap<>(100);

        for (V v : input) {

            try {
                K k = (K) getProperty(v, keyProperty);
                List<V> list = result.computeIfAbsent(k, k1 -> new ArrayList<>());
                list.add(v);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        return result;
    }

    /**
     * 将数组按n个一份拆分.
     *
     * @param <T> d
     * @param input d
     * @param n d
     * @return d
     */
    public static <T> List<List<T>> group(List<T> input, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must > 0");
        }

        int size = input.size();
        int m = (size + n - 1) / n;
        List<List<T>> result = new ArrayList<>(m);
        for (int i = 0; i < m; i++) {
            List<T> items = new ArrayList<>(n);
            int end = i < m - 1 ? n : size - i * n;
            for (int j = 0; j < end; j++) {
                items.add(input.get(i * n + j));
            }
            result.add(items);
        }
        return result;
    }

    /**
     * dd
     * @param parent d
     * @param child d
     * @return d
     */
    public static boolean containAny(Set parent, Set<Object> child) {
        if (parent == null || child == null) {
            return false;
        }
        for (Object o : child) {
            return parent.contains(o);
        }
        return false;
    }

    /**
     * dd
     * @param vs d
     * @param <V> d
     * @return d
     */
    public static <V> List<V> newArrayList(V... vs) {
        List<V> list = new ArrayList<>();
        list.addAll(Arrays.asList(vs));
        return list;
    }

    /**
     * 使用指定拼接符将集合拼接为字符串
     * @param list d
     * @param str d
     * @return d
     */
    public static  String concat(List list,String str){
        StringBuilder builder = new StringBuilder();
        for(Object obj:list){
            builder.append(obj.toString()).append(str);
        }
        return builder.substring(0,builder.toString().length()-1);
    }

    /**
     * ddd
     * @param bean d
     * @param name d
     * @return d
     */
    private static Object getProperty(Object bean,String name){
        return BeanUtils.getBeanProperty(bean,name);
    }

}
