/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.common.util;

import cn.net.vidyo.framework.common.util.MapUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.FatalBeanException;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.ClassUtils;

public class ObjectUtil {
    public static <T> T copyPropertiesSpecific(Object source, Class<T> clazz, String ... specificProperties) {
        Object target = BeanUtils.instantiate(clazz);
        return (T)ObjectUtil.copyPropertiesSpecific(source, target, specificProperties);
    }

    public static <T> T copyPropertiesSpecific(Object source, T target, String ... specificProperties) {
        if (source == null || target == null) {
            return target;
        }
        try {
            if (specificProperties == null) {
                return target;
            }
            List<String> specificList = Arrays.asList(specificProperties);
            ObjectUtil.copySpecificProperties(source, target, specificList);
            return target;
        }
        catch (Exception exception) {
            return target;
        }
    }

    public static void increaseColumnValue(Object t, String fieldName, Object delta) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(t);
        Object value = wrapper.getPropertyValue(fieldName);
        if (value instanceof Short) {
            value = (Short)value + (Short)delta;
        }
        if (value instanceof Integer) {
            value = (Integer)value + (Integer)delta;
        }
        if (value instanceof Long) {
            value = (Long)value + (Long)delta;
        }
        if (value instanceof Float) {
            value = Float.valueOf(((Float)value).floatValue() + ((Float)delta).floatValue());
        }
        if (value instanceof Double) {
            value = (Double)value + (Double)delta;
        }
        wrapper.setPropertyValue(fieldName, value);
    }

    private static void copySpecificProperties(Object source, Object target, Iterable<String> properties) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        BeanWrapperImpl trg = new BeanWrapperImpl(target);
        for (String propertyName : properties) {
            trg.setPropertyValue(propertyName, src.getPropertyValue(propertyName));
        }
    }

    public static <T> T copyPropertiesByNotDefaultValue(T source, T target, String ... ignoreProperties) {
        if (source == null || target == null) {
            return target;
        }
        Class<?> actualEditable = target.getClass();
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                Object value;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if (ObjectUtil.isDefaultValue(value = readMethod.invoke(source, new Object[0]))) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable var15) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", var15);
            }
        }
        return target;
    }

    public static boolean isDefaultValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Byte) {
            return ObjectUtil.isDefaultValue(value, 0);
        }
        if (value instanceof Short) {
            return ObjectUtil.isDefaultValue(value, 0);
        }
        if (value instanceof Integer) {
            return ObjectUtil.isDefaultValue(value, 0);
        }
        if (value instanceof Long) {
            return ObjectUtil.isDefaultValue(value, 0L);
        }
        if (value instanceof Float) {
            return ObjectUtil.isDefaultValue(value, Float.valueOf(0.0f));
        }
        if (value instanceof Double) {
            return ObjectUtil.isDefaultValue(value, 0.0);
        }
        if (value instanceof Character) {
            return ObjectUtil.isDefaultValue(value, null);
        }
        if (value instanceof String) {
            return ObjectUtil.isDefaultValue(value, null);
        }
        if (value instanceof Boolean) {
            return ObjectUtil.isDefaultValue(value, 0);
        }
        if (value instanceof Date) {
            return ObjectUtil.isDefaultValue(value, null);
        }
        return true;
    }

    public static boolean isDefaultValue(Object value, Object defaultValue) {
        if (value == null) {
            return true;
        }
        if (value == defaultValue) {
            return true;
        }
        if (value instanceof Short) {
            return (Short)value < (Short)defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value < (Integer)defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value < (Long)defaultValue;
        }
        return false;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap<String, Object> map = MapUtil.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> Object getFieldValueByFieldName(T t, String fieldName) {
        Class<?> clazz = t.getClass();
        Field resultField = ObjectUtil.getClassDeclaredFieldByFildName(clazz, true, fieldName);
        if (resultField == null) {
            return null;
        }
        Object obj = null;
        resultField.setAccessible(true);
        try {
            obj = resultField.get(t);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static List<Field> getClassDeclaredFields(Class classz, boolean mappedSuperclassSupport) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fs = classz.getDeclaredFields();
        Collections.addAll(fields, fs);
        if (mappedSuperclassSupport) {
            List<Field> list = ObjectUtil.getClassDeclaredFields(classz.getSuperclass(), mappedSuperclassSupport);
            fields.addAll(list);
        }
        return fields;
    }

    public static Field getClassDeclaredFieldByFildName(Class classz, boolean mappedSuperclassSupport, String fieldName) {
        Field[] fs;
        if (classz == null) {
            return null;
        }
        for (Field f : fs = classz.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        if (mappedSuperclassSupport) {
            return ObjectUtil.getClassDeclaredFieldByFildName(classz.getSuperclass(), mappedSuperclassSupport, fieldName);
        }
        return null;
    }
}

