/*
 * Decompiled with CFR 0.152.
 */
package cn.net.pap.common.pdf;

import cn.net.pap.common.pdf.sign.SignatureInterfaceImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Calendar;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;

public class PDFUtil {
    private static final float PDF_VERSION = 1.4f;
    private static final String PDF_PART = "1";
    private static final String PDF_CONFORMANCE = "A";

    public static void addStamp(String pdfFilePath, String imageFilePath, String outputFilePath) throws Exception {
        try (PDDocument document = Loader.loadPDF((File)new File(pdfFilePath));){
            PDPage page = document.getPage(0);
            PDImageXObject pdImage = PDImageXObject.createFromFile((String)imageFilePath, (PDDocument)document);
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true);){
                contentStream.drawImage(pdImage, 100.0f, 100.0f, (float)pdImage.getWidth(), (float)pdImage.getHeight());
            }
            document.save(outputFilePath);
        }
    }

    public static void addSign(String pdfFilePath, String keystorePath, String keystorePassword, String outputFilePath) throws Exception {
        try (PDDocument document = Loader.loadPDF((File)new File(pdfFilePath));){
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            try (FileInputStream fis = new FileInputStream(keystorePath);){
                keystore.load(fis, keystorePassword.toCharArray());
            }
            String alias = keystore.aliases().nextElement();
            PrivateKey privateKey = (PrivateKey)keystore.getKey(alias, keystorePassword.toCharArray());
            Certificate[] certificateChain = keystore.getCertificateChain(alias);
            PDSignature signature = new PDSignature();
            signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
            signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
            signature.setName("name");
            signature.setLocation("location");
            signature.setReason("reason");
            signature.setSignDate(Calendar.getInstance());
            SignatureOptions signatureOptions = new SignatureOptions();
            signatureOptions.setPreferredSignatureSize(9472);
            document.addSignature(signature, (SignatureInterface)new SignatureInterfaceImpl(privateKey, certificateChain), signatureOptions);
            try (FileOutputStream fos = new FileOutputStream(outputFilePath);){
                ExternalSigningSupport externalSigning = document.saveIncrementalForExternalSigning((OutputStream)fos);
                byte[] content = IOUtils.toByteArray((InputStream)externalSigning.getContent());
                byte[] signedContent = SignatureInterfaceImpl.signContent(content, privateKey, certificateChain);
                externalSigning.setSignature(signedContent);
            }
        }
    }

    public static void addProtect(String pdfFilePath, String ownerPassword, String userPassword, String outputFilePath) throws Exception {
        try (PDDocument document = Loader.loadPDF((File)new File(pdfFilePath));){
            AccessPermission accessPermission = new AccessPermission();
            accessPermission.setCanModify(false);
            StandardProtectionPolicy protectionPolicy = new StandardProtectionPolicy(ownerPassword, userPassword, accessPermission);
            protectionPolicy.setEncryptionKeyLength(128);
            document.protect((ProtectionPolicy)protectionPolicy);
            document.save(outputFilePath);
        }
    }

    public static void convertPDFA(String inputFilePath, String outputFilePath) throws Exception {
        File inputFile = new File(inputFilePath);
        File outputFile = new File(outputFilePath);
        byte[] inputContent = Files.readAllBytes(inputFile.getAbsoluteFile().toPath());
        InputStream colorSpaceProfileInputStream = PDFUtil.class.getClassLoader().getResourceAsStream("sRGB Color Space Profile.icm");
        PDDocument doc = Loader.loadPDF((byte[])inputContent);
        PDDocumentCatalog catalog = PDFUtil.setCompliant(doc, PDF_PART, PDF_CONFORMANCE);
        PDFUtil.addOutputIntent(doc, catalog, colorSpaceProfileInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        doc.setVersion(1.4f);
        doc.save((OutputStream)byteArrayOutputStream);
        doc.close();
        byte[] outputContent = byteArrayOutputStream.toByteArray();
        try (OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            outputStream.write(outputContent);
        }
    }

    private static PDDocumentCatalog setCompliant(PDDocument doc, String pdfPart, String pdfConformance) throws IOException, Exception {
        PDDocumentCatalog catalog = doc.getDocumentCatalog();
        PDDocumentInformation info = doc.getDocumentInformation();
        PDMetadata metadata = new PDMetadata(doc);
        catalog.setMetadata(metadata);
        PDDocumentInformation newInfo = new PDDocumentInformation();
        newInfo.setProducer(info.getProducer());
        newInfo.setAuthor(info.getAuthor());
        newInfo.setTitle(info.getTitle());
        newInfo.setSubject(info.getSubject());
        newInfo.setKeywords(info.getKeywords());
        doc.setDocumentInformation(newInfo);
        Charset charset = StandardCharsets.UTF_8;
        InputStream is = PDFUtil.class.getClassLoader().getResourceAsStream("xmpTemplate.xml");
        byte[] fileBytes = IOUtils.toByteArray((InputStream)is);
        String content = new String(fileBytes, charset);
        content = content.replace("@#pdfaid:part#@", pdfPart);
        content = content.replace("@#pdfaid:conformance#@", pdfConformance);
        is.close();
        byte[] editedBytes = content.getBytes(charset);
        metadata.importXMPMetadata(editedBytes);
        return catalog;
    }

    private static void addOutputIntent(PDDocument doc, PDDocumentCatalog catalog, InputStream colorProfile) throws IOException {
        String profile = "sRGB IEC61966-2.1";
        if (catalog.getOutputIntents().isEmpty()) {
            PDOutputIntent outputIntent = new PDOutputIntent(doc, colorProfile);
            outputIntent.setInfo("sRGB IEC61966-2.1");
            outputIntent.setOutputCondition("sRGB IEC61966-2.1");
            outputIntent.setOutputConditionIdentifier("sRGB IEC61966-2.1");
            outputIntent.setRegistryName("http://www.color.org");
            catalog.addOutputIntent(outputIntent);
        }
    }
}

