/*
 * Decompiled with CFR 0.152.
 */
package cn.net.pap.common.docx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * Exception performing whole class analysis ignored.
 */
public class Html2DocxUtils {
    private static final StringBuffer htmlHeader = new StringBuffer("<html><head><meta charset=\"utf-8\"><title></title></head><body>");
    private static final StringBuffer htmlFotter = new StringBuffer("</body></html>");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean html2docx2UsingPOI(StringBuffer html, String docxAbsPath) {
        FileOutputStream outputStream = null;
        ByteArrayInputStream bais = null;
        try {
            outputStream = new FileOutputStream(docxAbsPath);
            StringBuffer all = new StringBuffer().append(htmlHeader).append(html).append(htmlFotter);
            String converted = Html2DocxUtils.image2Base64Convert((String)all.toString());
            byte[] b = converted.getBytes();
            bais = new ByteArrayInputStream(b);
            POIFSFileSystem poifs = new POIFSFileSystem();
            DirectoryNode directory = poifs.getRoot();
            directory.createDocument("WordDocument", (InputStream)bais);
            poifs.writeFilesystem((OutputStream)outputStream);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static String image2Base64Convert(String html) throws IOException {
        Document doc = Jsoup.parse((String)html);
        Elements images = doc.select("img[src]");
        for (Element image : images) {
            String[] styleRules;
            String style;
            String src = image.attr("src");
            if (src.startsWith("http")) {
                String base64Image = Html2DocxUtils.convertImageToBase64((String)src);
                image.attr("src", base64Image);
            }
            if ((style = image.attr("style")) == null || style.isEmpty()) continue;
            Boolean widthBool = false;
            for (String rule : styleRules = style.split(";")) {
                if ((rule = rule.trim()).startsWith("width")) {
                    image.attr("width", rule.substring(rule.indexOf(":") + 1).trim());
                    widthBool = true;
                }
                if (!rule.startsWith("height")) continue;
                image.attr("height", rule.substring(rule.indexOf(":") + 1).trim());
            }
            if (!widthBool.booleanValue()) {
                image.attr("width", "530");
            }
            image.attr("style", "max-width: 100%; max-height: 100%; height: auto; width: auto;");
        }
        return doc.html();
    }

    private static String convertImageToBase64(String imageUrl) throws IOException {
        int bytesRead;
        URL url = new URL(imageUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.connect();
        String contentType = connection.getContentType();
        Object mimeType = "data:image/";
        if (contentType.contains("jpeg") || contentType.contains("jpg")) {
            mimeType = (String)mimeType + "jpeg;base64,";
        } else if (contentType.contains("png")) {
            mimeType = (String)mimeType + "png;base64,";
        } else if (contentType.contains("gif")) {
            mimeType = (String)mimeType + "gif;base64,";
        }
        InputStream input = connection.getInputStream();
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        input.close();
        byte[] imageBytes = output.toByteArray();
        String base64Image = Base64.getEncoder().encodeToString(imageBytes);
        return (String)mimeType + base64Image;
    }
}

