/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql;

import com.mugui.Mugui;
import com.mugui.sql.DBConf;
import com.mugui.sql.SqlUtils;
import com.mugui.sql.TableMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SqlServer
implements Mugui {
    private static final ThreadLocal<HashMap<String, SqlUtils>> threadLocal = new ThreadLocal();
    private static int LIMIT_MAX_SIZE = 2000;
    private DBConf dbConf = null;
    private static final ThreadLocal<Boolean> AUTO_COMMIT = new ThreadLocal();
    private static final ThreadLocal<Boolean> LOCK_OF_SELECT = new ThreadLocal();
    private static List<SelectListener> listeners = null;

    static {
        SqlServer.addSelectListener(new SelectListenerImpl(){

            @Override
            public String handleSql(String sql) {
                if (sql.toLowerCase().indexOf("limit") < 0) {
                    sql = sql.replaceAll("[;]", " ");
                    sql = String.valueOf(sql) + " limit 0," + LIMIT_MAX_SIZE;
                }
                return sql;
            }
        });
    }

    public void setLIMIT_MAX_SIZE(int limit_max_size) {
        LIMIT_MAX_SIZE = limit_max_size;
    }

    public SqlServer() {
        this.dbConf = DBConf.getDefaultDBConf();
    }

    public SqlServer(String url) {
        this.dbConf = DBConf.getDBConf(url);
    }

    public void setAutoCommit(boolean bool) throws Exception {
        AUTO_COMMIT.set(bool);
    }

    public boolean isAutoCommit() {
        return AUTO_COMMIT.get() != null ? AUTO_COMMIT.get() : false;
    }

    public void setLockOfSelect(boolean lock_of_update) {
        LOCK_OF_SELECT.set(lock_of_update);
    }

    public void commit() throws SQLException, Exception {
        HashMap<String, SqlUtils> hashMap = threadLocal.get();
        if (hashMap == null) {
            return;
        }
        for (SqlUtils sqlUtils : hashMap.values()) {
            try {
                sqlUtils.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SqlServer.reback();
    }

    public static void reback() {
        HashMap<String, SqlUtils> hashMap = threadLocal.get();
        if (hashMap == null) {
            return;
        }
        for (SqlUtils sqlUtils : hashMap.values()) {
            try {
                sqlUtils.Close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        hashMap.clear();
        AUTO_COMMIT.set(true);
        LOCK_OF_SELECT.set(false);
    }

    public void rollback() throws Exception {
        try {
            this.getSqlUtils().rollback();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TableMode selectBy(String sql_name, Object ... params) {
        String sql = this.dbConf.getSQL(sql_name);
        if (sql == null) {
            throw new NullPointerException(String.valueOf(sql_name) + " SQL is not find of " + this.dbConf);
        }
        return this.select(sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void addSelectListener(SelectListener listener) {
        if (listeners == null) {
            Class<SqlServer> clazz = SqlServer.class;
            // MONITORENTER : com.mugui.sql.SqlServer.class
            if (listeners == null) {
                listeners = new ArrayList<SelectListener>(){
                    private static final long serialVersionUID = -7234167947506229832L;

                    @Override
                    public boolean add(SelectListener e) {
                        super.add(0, e);
                        return true;
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void removeSelectListener(SelectListener listener) {
        if (listeners == null) {
            Class<SqlServer> clazz = SqlServer.class;
            // MONITORENTER : com.mugui.sql.SqlServer.class
            if (listeners == null) {
                listeners = new ArrayList<SelectListener>(){
                    private static final long serialVersionUID = -7234167947506229832L;

                    @Override
                    public boolean add(SelectListener e) {
                        super.add(0, e);
                        return true;
                    }
                };
            }
            // MONITOREXIT : clazz
        }
        listeners.remove(listener);
    }

    public TableMode select(String sql, Object ... params) {
        if (listeners != null && !listeners.isEmpty()) {
            for (SelectListener listener : listeners) {
                sql = listener.handleSql(sql);
                params = listener.handlePar(params);
            }
        }
        SqlUtils sqlUtils = null;
        try {
            sqlUtils = this.getSqlUtils();
            ResultSet set = sqlUtils.select(sql, params);
            TableMode tableMode = new TableMode(set);
            return tableMode;
        }
        catch (Exception e) {
            System.out.println("sql:" + sql + "\r\nparams:" + Arrays.toString(params));
            this.closeConnection(sqlUtils);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            sqlUtils.closePreparedStatement();
        }
    }

    private SqlUtils getSqlUtils() {
        SqlUtils sqlUtils;
        HashMap<String, SqlUtils> hashMap = threadLocal.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            threadLocal.set(hashMap);
        }
        if ((sqlUtils = hashMap.get(this.dbConf.getUrl())) == null) {
            sqlUtils = new SqlUtils(this.dbConf);
            hashMap.put(this.dbConf.getUrl(), sqlUtils);
        } else {
            while (true) {
                ResultSet select = null;
                try {
                    select = sqlUtils.select("select 1", null);
                    select.close();
                    sqlUtils.closePreparedStatement();
                }
                catch (SQLException e) {
                    try {
                        if (select != null) {
                            select.close();
                        }
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    sqlUtils.closePreparedStatement();
                    sqlUtils.Close();
                    sqlUtils = new SqlUtils(this.dbConf);
                    hashMap.put(this.dbConf.getUrl(), sqlUtils);
                    continue;
                }
                break;
            }
        }
        try {
            if (AUTO_COMMIT.get() != null) {
                sqlUtils.setAutoCommit(AUTO_COMMIT.get());
            }
            if (LOCK_OF_SELECT.get() != null) {
                sqlUtils.setLockOfSelect(LOCK_OF_SELECT.get());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sqlUtils;
    }

    public boolean updateBy(String sql_name, Object ... params) {
        String sql = this.dbConf.getSQL(sql_name);
        if (sql == null) {
            throw new NullPointerException(String.valueOf(sql_name) + " SQL is not find of " + this.dbConf);
        }
        return this.update(sql, params);
    }

    public String getSql(String sql_name) {
        return this.dbConf.getSQL(sql_name);
    }

    public boolean update(String sql, Object ... params) {
        if (sql == null || sql.isEmpty()) {
            throw new NullPointerException("sql is null");
        }
        SqlUtils sqlUtils = null;
        try {
            int flag = 0;
            sqlUtils = this.getSqlUtils();
            flag = sqlUtils.update(sql, params);
            boolean bl = flag > 0;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("sql:" + sql + "\r\nparams:" + Arrays.toString(params));
            this.closeConnection(sqlUtils);
            throw new RuntimeException(e);
        }
        finally {
            sqlUtils.closePreparedStatement();
        }
    }

    private void closeConnection(SqlUtils sqlUtils) {
        try {
            try {
                sqlUtils.rollback();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                sqlUtils.Close();
            }
        }
        finally {
            sqlUtils.Close();
        }
    }

    public void batchSQL(String[] sqls) {
        if (sqls == null || sqls.length == 0) {
            throw new NullPointerException("sqls is null");
        }
        SqlUtils sqlUtils = null;
        try {
            try {
                sqlUtils = this.getSqlUtils();
                sqlUtils.batch(sqls);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeConnection(sqlUtils);
                throw new RuntimeException(e);
            }
        }
        finally {
            sqlUtils.closePreparedStatement();
        }
    }

    public static interface SelectListener {
        public String handleSql(String var1);

        public Object[] handlePar(Object ... var1);
    }

    public static class SelectListenerImpl
    implements SelectListener {
        @Override
        public String handleSql(String sql) {
            return sql;
        }

        @Override
        public Object[] handlePar(Object ... objects) {
            return objects;
        }
    }
}

