/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.sql.loader;

import com.mugui.bean.JsonBean;
import com.mugui.sql.JsonBeanAttr;
import com.mugui.sql.loader.Parameter;
import com.mugui.sql.loader.Select;
import java.lang.reflect.Field;
import java.util.List;

public class Where
extends Parameter {
    private static final long serialVersionUID = 8792016834022466177L;

    public static Where q() {
        return new Where();
    }

    public static Where q(JsonBean ... attrs) {
        return new Where().query(attrs);
    }

    public Where() {
        this.sql = new StringBuilder();
    }

    public Where query(JsonBean ... attrs) {
        this.queryEqualFields(attrs);
        this.queryBaseTerm(attrs);
        return this;
    }

    public void queryBaseTerm(JsonBean ... attrs) {
        JsonBean[] jsonBeanArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            JsonBean bean = jsonBeanArray[n2];
            List<Field> fields = JsonBeanAttr.getAttr(bean).getFields();
            for (Field f : fields) {
                f.setAccessible(true);
                try {
                    Object object = f.get(bean);
                    if (object == null) continue;
                    this.and("`" + JsonBeanAttr.getAttr(bean).getTABLE() + "`.`" + f.getName() + "`", object);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public Where and(String name, Object object) {
        if (this.sql == null) {
            this.sql = new StringBuilder();
        }
        this.sql.append(" AND ");
        this.sql.append(" ").append(name).append("=?");
        this.addParameter(object);
        return this;
    }

    public Where queryEqualFields(JsonBean ... attrs) {
        JsonBeanAttr attr = JsonBeanAttr.getAttr(attrs[0]);
        int j = 1;
        while (j < attrs.length) {
            String[] equalFields;
            JsonBeanAttr attr2 = JsonBeanAttr.getAttr(attrs[j]);
            String[] stringArray = equalFields = attr.equalFields(attrs[j]);
            int n = equalFields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                if (!this.sql.toString().equals("")) {
                    this.sql.append(" AND ");
                }
                this.sql.append(" `").append(attr.getTABLE()).append("`.`").append(String.valueOf(field) + "`=").append("`" + attr2.getTABLE()).append("`.").append(field).append("` ");
                ++n2;
            }
            ++j;
        }
        return this;
    }

    public Where in(String filed_name, String value) {
        this.sql.append(" AND ");
        this.sql.append("`" + filed_name + "`").append(" in (").append(value.toString()).append(") ");
        return this;
    }

    public Where in(String filed_name, Select value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append(" in (").append(value.toString()).append(") ");
        this.addParameter(value.getParameter());
        return this;
    }

    public Where like(String filed_name, Object value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append(" like '%").append(value).append("%' ");
        return this;
    }

    public Where eq(String filed_name, Object value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append("=? ");
        this.addParameter(value);
        return this;
    }

    public Where ne(String filed_name, Object value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append("!=?");
        this.addParameter(value);
        return this;
    }

    public Where gt(String filed_name, Object value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append(">?");
        this.addParameter(value);
        return this;
    }

    public Where lt(String filed_name, Object value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append("<?");
        this.addParameter(value);
        return this;
    }

    public Where ge(String filed_name, Object value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append(">=?");
        this.addParameter(value);
        return this;
    }

    public Where le(String filed_name, Object value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append("<=?");
        this.addParameter(value);
        return this;
    }

    public Where between(String filed_name, String start, String end) {
        String term = "'" + start + "','" + end + "'";
        this.sql.append(" and ").append("`" + filed_name + "`").append(" BETWEEN ").append(term);
        return this;
    }

    public Where orderByDESC(String filed_name) {
        this.sql.append(" order by ").append("`" + filed_name + "`").append(" DESC");
        return this;
    }

    public Where orderByDESCKeyId(JsonBean bean) {
        return this.orderByDESC(JsonBeanAttr.getAttr(bean).getKEY());
    }

    public Where orderByASC(String filed_name) {
        this.sql.append(" order by ").append("`" + filed_name + "`").append(" ASC");
        return this;
    }

    public Where orderByASCKeyId(JsonBean bean) {
        return this.orderByASC(JsonBeanAttr.getAttr(bean).getKEY());
    }

    public Where groupBy(String filed_name) {
        this.sql.append(" GROUP BY ").append("`" + filed_name + "`");
        return this;
    }

    public Where notIn(String filed_name, String value) {
        this.sql.append(" and ").append("`" + filed_name + "`").append(" NOT IN (").append(value).append(") ");
        return this;
    }

    public Where neNull(String filed_name) {
        this.sql.append(" and ").append("`" + filed_name + "`").append("!=null ");
        return this;
    }

    public Where isNotNull(String filed_name) {
        this.sql.append(" and ").append("`" + filed_name + "`").append(" is NOT null ");
        return this;
    }

    public Where isNull(String filed_name) {
        this.sql.append(" and ").append("`" + filed_name + "`").append(" is null ");
        return this;
    }

    public Where limit(int filed_name) {
        this.sql.append(" limit ").append("`" + filed_name + "`");
        return this;
    }

    public Where union(String filed_name) {
        String[] split = filed_name.split(",");
        int i = 0;
        while (i < split.length) {
            if (i == split.length - 1) {
                this.sql.append(split[i]);
            } else {
                this.sql.append(split[i]).append(" UNION ");
            }
            ++i;
        }
        return this;
    }

    public Where unionAll(String filed_name) {
        String[] split = filed_name.split(",");
        int i = 0;
        while (i < split.length) {
            if (i == split.length - 1) {
                this.sql.append(split[i]);
            } else {
                this.sql.append(split[i]).append(" UNION ALL ");
            }
            ++i;
        }
        return this;
    }

    public Where where(String sqlName) {
        this.sql.append(sqlName);
        return this;
    }
}

