/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class MappedInterceptor
implements HandlerInterceptor {
    private static PathMatcher defaultPathMatcher = new AntPathMatcher();
    @Nullable
    private final PathPattern[] includePatterns;
    @Nullable
    private final PathPattern[] excludePatterns;
    private PathMatcher pathMatcher = defaultPathMatcher;
    private final HandlerInterceptor interceptor;

    public MappedInterceptor(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, HandlerInterceptor interceptor, @Nullable PathPatternParser parser) {
        this.includePatterns = MappedInterceptor.initPatterns(includePatterns, parser);
        this.excludePatterns = MappedInterceptor.initPatterns(excludePatterns, parser);
        this.interceptor = interceptor;
    }

    @Nullable
    private static PathPattern[] initPatterns(@Nullable String[] patterns, @Nullable PathPatternParser parser) {
        if (ObjectUtils.isEmpty(patterns)) {
            return null;
        }
        parser = parser != null ? parser : PathPatternParser.defaultInstance;
        return (PathPattern[])Arrays.stream(patterns).map(parser::parse).toArray(PathPattern[]::new);
    }

    public MappedInterceptor(@Nullable String[] includePatterns, HandlerInterceptor interceptor) {
        this(includePatterns, null, interceptor);
    }

    public MappedInterceptor(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, HandlerInterceptor interceptor) {
        this(includePatterns, excludePatterns, interceptor, null);
    }

    public MappedInterceptor(@Nullable String[] includePatterns, WebRequestInterceptor interceptor) {
        this(includePatterns, null, interceptor);
    }

    public MappedInterceptor(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, WebRequestInterceptor interceptor) {
        this(includePatterns, excludePatterns, new WebRequestHandlerInterceptorAdapter(interceptor));
    }

    @Nullable
    public String[] getPathPatterns() {
        return !ObjectUtils.isEmpty(this.includePatterns) ? (String[])Arrays.stream(this.includePatterns).map(PathPattern::getPatternString).toArray(String[]::new) : null;
    }

    public HandlerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public boolean matches(HttpServletRequest request) {
        Object path = ServletRequestPathUtils.getCachedPath(request);
        if (this.pathMatcher != defaultPathMatcher) {
            path = path.toString();
        }
        boolean isPathContainer = path instanceof PathContainer;
        if (!ObjectUtils.isEmpty(this.excludePatterns)) {
            for (PathPattern pattern : this.excludePatterns) {
                if (!this.matchPattern(path, isPathContainer, pattern)) continue;
                return false;
            }
        }
        if (ObjectUtils.isEmpty(this.includePatterns)) {
            return true;
        }
        for (PathPattern pattern : this.includePatterns) {
            if (!this.matchPattern(path, isPathContainer, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean matchPattern(Object path, boolean isPathContainer, PathPattern pattern) {
        return isPathContainer ? pattern.matches((PathContainer)path) : this.pathMatcher.match(pattern.getPatternString(), (String)path);
    }

    @Deprecated
    public boolean matches(String lookupPath, PathMatcher pathMatcher) {
        PathMatcher pathMatcher2 = pathMatcher = this.pathMatcher != defaultPathMatcher ? this.pathMatcher : pathMatcher;
        if (!ObjectUtils.isEmpty(this.excludePatterns)) {
            for (PathPattern pattern : this.excludePatterns) {
                if (!pathMatcher.match(pattern.getPatternString(), lookupPath)) continue;
                return false;
            }
        }
        if (ObjectUtils.isEmpty(this.includePatterns)) {
            return true;
        }
        for (PathPattern pattern : this.includePatterns) {
            if (!pathMatcher.match(pattern.getPatternString(), lookupPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return this.interceptor.preHandle(request, response, handler);
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        this.interceptor.postHandle(request, response, handler, modelAndView);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        this.interceptor.afterCompletion(request, response, handler, ex);
    }
}

