/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

class LettuceReactiveHyperLogLogCommands
implements ReactiveHyperLogLogCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveHyperLogLogCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfAddCommand, Long>> pfAdd(Publisher<ReactiveHyperLogLogCommands.PfAddCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "key must not be null!");
            return cmd.pfadd((Object)command.getKey(), (Object[])command.getValues().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfAddCommand, Long>((ReactiveHyperLogLogCommands.PfAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfCountCommand, Long>> pfCount(Publisher<ReactiveHyperLogLogCommands.PfCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notEmpty(command.getKeys(), "Keys must not be empty for PFCOUNT.");
            return cmd.pfcount((Object[])command.getKeys().stream().toArray(ByteBuffer[]::new)).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfCountCommand, Long>((ReactiveHyperLogLogCommands.PfCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHyperLogLogCommands.PfMergeCommand>> pfMerge(Publisher<ReactiveHyperLogLogCommands.PfMergeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null for PFMERGE.");
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null for PFMERGE.");
            return cmd.pfmerge((Object)command.getKey(), (Object[])command.getSourceKeys().stream().toArray(ByteBuffer[]::new)).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveHyperLogLogCommands.PfMergeCommand>((ReactiveHyperLogLogCommands.PfMergeCommand)command, (Boolean)value));
        }));
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

