/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.SortArgs;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.connection.lettuce.LettuceScanCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceKeyCommands
implements RedisKeyCommands {
    private final LettuceConnection connection;

    LettuceKeyCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean exists(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().exists((Object[])new byte[][]{key}), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().exists((Object[])new byte[][]{key}), LettuceConverters.longToBooleanConverter()));
                return null;
            }
            return LettuceConverters.longToBooleanConverter().convert(this.getConnection().exists((Object[])new byte[][]{key}));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Long exists(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null!");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().exists((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().exists((Object[])keys)));
                return null;
            }
            return this.getConnection().exists((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null!");
        Assert.noNullElements((Object[])keys, "Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().del((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().del((Object[])keys)));
                return null;
            }
            return this.getConnection().del((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long unlink(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().unlink((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().unlink((Object[])keys)));
                return null;
            }
            return this.getConnection().unlink((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().type((Object)key), LettuceConverters.stringToDataType()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().type((Object)key), LettuceConverters.stringToDataType()));
                return null;
            }
            return LettuceConverters.toDataType(this.getConnection().type((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long touch(byte[] ... keys) {
        Assert.notNull((Object)keys, "Keys must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().touch((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().touch((Object[])keys)));
                return null;
            }
            return this.getConnection().touch((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        Assert.notNull((Object)pattern, "Pattern must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().keys((Object)pattern), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().keys((Object)pattern), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().keys((Object)pattern));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    public Cursor<byte[]> scan() {
        return this.scan(ScanOptions.NONE);
    }

    @Override
    public Cursor<byte[]> scan(ScanOptions options) {
        return this.doScan(options != null ? options : ScanOptions.NONE);
    }

    private Cursor<byte[]> doScan(ScanOptions options) {
        return new LettuceScanCursor<byte[]>(options){

            @Override
            protected LettuceScanCursor.LettuceScanIteration<byte[]> doScan(ScanCursor cursor, ScanOptions options) {
                if (LettuceKeyCommands.this.isQueueing() || LettuceKeyCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                KeyScanCursor keyScanCursor = LettuceKeyCommands.this.getConnection().scan(cursor, scanArgs);
                List keys = keyScanCursor.getKeys();
                return new LettuceScanCursor.LettuceScanIteration<byte[]>((ScanCursor)keyScanCursor, keys);
            }

            @Override
            protected void doClose() {
                LettuceKeyCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().randomkey()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().randomkey()));
                return null;
            }
            return (byte[])this.getConnection().randomkey();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, "Source key must not be null!");
        Assert.notNull((Object)targetKey, "Target key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().rename((Object)sourceKey, (Object)targetKey)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().rename((Object)sourceKey, (Object)targetKey)));
                return;
            }
            this.getConnection().rename((Object)sourceKey, (Object)targetKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, "Source key must not be null!");
        Assert.notNull((Object)targetKey, "Target key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().renamenx((Object)sourceKey, (Object)targetKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().renamenx((Object)sourceKey, (Object)targetKey)));
                return null;
            }
            return this.getConnection().renamenx((Object)sourceKey, (Object)targetKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().expire((Object)key, seconds)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().expire((Object)key, seconds)));
                return null;
            }
            return this.getConnection().expire((Object)key, seconds);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte[] key, long millis) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pexpire((Object)key, millis)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pexpire((Object)key, millis)));
                return null;
            }
            return this.getConnection().pexpire((Object)key, millis);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().expireat((Object)key, unixTime)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().expireat((Object)key, unixTime)));
                return null;
            }
            return this.getConnection().expireat((Object)key, unixTime);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pexpireat((Object)key, unixTimeInMillis)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pexpireat((Object)key, unixTimeInMillis)));
                return null;
            }
            return this.getConnection().pexpireat((Object)key, unixTimeInMillis);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().persist((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().persist((Object)key)));
                return null;
            }
            return this.getConnection().persist((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().move((Object)key, dbIndex)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().move((Object)key, dbIndex)));
                return null;
            }
            return this.getConnection().move((Object)key, dbIndex);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().ttl((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().ttl((Object)key)));
                return null;
            }
            return this.getConnection().ttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().ttl((Object)key), Converters.secondsToTimeUnit(timeUnit)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().ttl((Object)key), Converters.secondsToTimeUnit(timeUnit)));
                return null;
            }
            return Converters.secondsToTimeUnit(this.getConnection().ttl((Object)key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pttl((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pttl((Object)key)));
                return null;
            }
            return this.getConnection().pttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().pttl((Object)key), Converters.millisecondsToTimeUnit(timeUnit)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().pttl((Object)key), Converters.millisecondsToTimeUnit(timeUnit)));
                return null;
            }
            return Converters.millisecondsToTimeUnit(this.getConnection().pttl((Object)key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Assert.notNull((Object)key, "Key must not be null!");
        SortArgs args = LettuceConverters.toSortArgs(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().sort((Object)key, args)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().sort((Object)key, args)));
                return null;
            }
            return this.getConnection().sort((Object)key, args);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        Assert.notNull((Object)key, "Key must not be null!");
        SortArgs args = LettuceConverters.toSortArgs(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().sortStore((Object)key, args, (Object)sortKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().sortStore((Object)key, args, (Object)sortKey)));
                return null;
            }
            return this.getConnection().sortStore((Object)key, args, (Object)sortKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] dump(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().dump((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().dump((Object)key)));
                return null;
            }
            return this.getConnection().dump((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)serializedValue, "Serialized value must not be null!");
        try {
            RestoreArgs restoreArgs = RestoreArgs.Builder.ttl((long)ttlInMillis).replace(replace);
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().restore((Object)key, serializedValue, restoreArgs)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().restore((Object)key, serializedValue, restoreArgs)));
                return;
            }
            this.getConnection().restore((Object)key, serializedValue, restoreArgs);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    @Nullable
    public ValueEncoding encodingOf(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().objectEncoding((Object)key), ValueEncoding::of, () -> ValueEncoding.RedisValueEncoding.VACANT));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().objectEncoding((Object)key), ValueEncoding::of, () -> ValueEncoding.RedisValueEncoding.VACANT));
                return null;
            }
            return ValueEncoding.of(this.getConnection().objectEncoding((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Duration idletime(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().objectIdletime((Object)key), Converters::secondsToDuration));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().objectIdletime((Object)key), Converters::secondsToDuration));
                return null;
            }
            return Converters.secondsToDuration(this.getConnection().objectIdletime((Object)key));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Long refcount(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().objectRefcount((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().objectRefcount((Object)key)));
                return null;
            }
            return this.getConnection().objectRefcount((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }
}

