/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.convert;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class SetConverter<S, T>
implements Converter<Set<S>, Set<T>> {
    private Converter<S, T> itemConverter;

    public SetConverter(Converter<S, T> itemConverter) {
        Assert.notNull(itemConverter, "ItemConverter must not be null!");
        this.itemConverter = itemConverter;
    }

    @Override
    public Set<T> convert(Set<S> source) {
        return source.stream().map(this.itemConverter::convert).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

