/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisStaticMasterReplicaConfiguration
implements RedisConfiguration,
RedisConfiguration.StaticMasterReplicaConfiguration {
    private static final int DEFAULT_PORT = 6379;
    private List<RedisStandaloneConfiguration> nodes = new ArrayList<RedisStandaloneConfiguration>();
    private int database;
    @Nullable
    private String username = null;
    private RedisPassword password = RedisPassword.none();

    public RedisStaticMasterReplicaConfiguration(String hostName) {
        this(hostName, 6379);
    }

    public RedisStaticMasterReplicaConfiguration(String hostName, int port) {
        this.addNode(hostName, port);
    }

    public void addNode(String hostName, int port) {
        this.addNode(new RedisStandaloneConfiguration(hostName, port));
    }

    private void addNode(RedisStandaloneConfiguration node) {
        Assert.notNull((Object)node, "RedisStandaloneConfiguration must not be null!");
        node.setPassword(this.password);
        node.setDatabase(this.database);
        this.nodes.add(node);
    }

    public RedisStaticMasterReplicaConfiguration node(String hostName) {
        return this.node(hostName, 6379);
    }

    public RedisStaticMasterReplicaConfiguration node(String hostName, int port) {
        this.addNode(hostName, port);
        return this;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue(index >= 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
        this.nodes.forEach(it -> it.setDatabase(this.database));
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, "RedisPassword must not be null!");
        this.password = password;
        this.nodes.forEach(it -> it.setPassword(password));
    }

    @Override
    public List<RedisStandaloneConfiguration> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }
}

