/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.Assert;

public class LoggingSystemProperties {
    public static final String PID_KEY = "PID";
    public static final String EXCEPTION_CONVERSION_WORD = "LOG_EXCEPTION_CONVERSION_WORD";
    public static final String LOG_FILE = "LOG_FILE";
    public static final String LOG_PATH = "LOG_PATH";
    public static final String CONSOLE_LOG_PATTERN = "CONSOLE_LOG_PATTERN";
    public static final String CONSOLE_LOG_CHARSET = "CONSOLE_LOG_CHARSET";
    public static final String FILE_LOG_PATTERN = "FILE_LOG_PATTERN";
    public static final String FILE_LOG_CHARSET = "FILE_LOG_CHARSET";
    @Deprecated
    public static final String ROLLING_FILE_NAME_PATTERN = "ROLLING_FILE_NAME_PATTERN";
    @Deprecated
    public static final String FILE_CLEAN_HISTORY_ON_START = "LOG_FILE_CLEAN_HISTORY_ON_START";
    @Deprecated
    public static final String FILE_MAX_SIZE = "LOG_FILE_MAX_SIZE";
    @Deprecated
    public static final String FILE_TOTAL_SIZE_CAP = "LOG_FILE_TOTAL_SIZE_CAP";
    @Deprecated
    public static final String FILE_MAX_HISTORY = "LOG_FILE_MAX_HISTORY";
    public static final String LOG_LEVEL_PATTERN = "LOG_LEVEL_PATTERN";
    public static final String LOG_DATEFORMAT_PATTERN = "LOG_DATEFORMAT_PATTERN";
    private static final BiConsumer<String, String> systemPropertySetter = (name, value) -> {
        if (System.getProperty(name) == null && value != null) {
            System.setProperty(name, value);
        }
    };
    private final Environment environment;
    private final BiConsumer<String, String> setter;

    public LoggingSystemProperties(Environment environment2) {
        this(environment2, systemPropertySetter);
    }

    public LoggingSystemProperties(Environment environment2, BiConsumer<String, String> setter) {
        Assert.notNull((Object)environment2, "Environment must not be null");
        Assert.notNull(setter, "Setter must not be null");
        this.environment = environment2;
        this.setter = setter;
    }

    protected Charset getDefaultCharset() {
        return StandardCharsets.UTF_8;
    }

    public final void apply() {
        this.apply(null);
    }

    public final void apply(LogFile logFile) {
        PropertyResolver resolver = this.getPropertyResolver();
        this.apply(logFile, resolver);
    }

    protected void apply(LogFile logFile, PropertyResolver resolver) {
        this.setSystemProperty(resolver, EXCEPTION_CONVERSION_WORD, "logging.exception-conversion-word");
        this.setSystemProperty(PID_KEY, new ApplicationPid().toString());
        this.setSystemProperty(resolver, CONSOLE_LOG_PATTERN, "logging.pattern.console");
        this.setSystemProperty(resolver, CONSOLE_LOG_CHARSET, "logging.charset.console", this.getDefaultCharset().name());
        this.setSystemProperty(resolver, LOG_DATEFORMAT_PATTERN, "logging.pattern.dateformat");
        this.setSystemProperty(resolver, FILE_LOG_PATTERN, "logging.pattern.file");
        this.setSystemProperty(resolver, FILE_LOG_CHARSET, "logging.charset.file", this.getDefaultCharset().name());
        this.setSystemProperty(resolver, LOG_LEVEL_PATTERN, "logging.pattern.level");
        this.applyDeprecated(resolver);
        if (logFile != null) {
            logFile.applyToSystemProperties();
        }
    }

    private void applyDeprecated(PropertyResolver resolver) {
        this.setSystemProperty(resolver, FILE_CLEAN_HISTORY_ON_START, "logging.file.clean-history-on-start");
        this.setSystemProperty(resolver, FILE_MAX_HISTORY, "logging.file.max-history");
        this.setSystemProperty(resolver, FILE_MAX_SIZE, "logging.file.max-size");
        this.setSystemProperty(resolver, FILE_TOTAL_SIZE_CAP, "logging.file.total-size-cap");
        this.setSystemProperty(resolver, ROLLING_FILE_NAME_PATTERN, "logging.pattern.rolling-file-name");
    }

    private PropertyResolver getPropertyResolver() {
        if (this.environment instanceof ConfigurableEnvironment) {
            PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(((ConfigurableEnvironment)this.environment).getPropertySources());
            resolver.setConversionService(((ConfigurableEnvironment)this.environment).getConversionService());
            resolver.setIgnoreUnresolvableNestedPlaceholders(true);
            return resolver;
        }
        return this.environment;
    }

    protected final void setSystemProperty(PropertyResolver resolver, String systemPropertyName, String propertyName) {
        this.setSystemProperty(resolver, systemPropertyName, propertyName, null);
    }

    protected final void setSystemProperty(PropertyResolver resolver, String systemPropertyName, String propertyName, String defaultValue) {
        String value = resolver.getProperty(propertyName);
        value = value != null ? value : defaultValue;
        this.setSystemProperty(systemPropertyName, value);
    }

    protected final void setSystemProperty(String name, String value) {
        this.setter.accept(name, value);
    }
}

