/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

class LocationResourceLoader {
    private static final Resource[] EMPTY_RESOURCES = new Resource[0];
    private static final Comparator<File> FILE_PATH_COMPARATOR = Comparator.comparing(File::getAbsolutePath);
    private static final Comparator<File> FILE_NAME_COMPARATOR = Comparator.comparing(File::getName);
    private final ResourceLoader resourceLoader;

    LocationResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    boolean isPattern(String location) {
        return StringUtils.hasLength(location) && location.contains("*");
    }

    Resource getResource(String location) {
        this.validateNonPattern(location);
        location = StringUtils.cleanPath(location);
        if (!ResourceUtils.isUrl(location)) {
            location = "file:" + location;
        }
        return this.resourceLoader.getResource(location);
    }

    private void validateNonPattern(String location) {
        Assert.state(!this.isPattern(location), () -> String.format("Location '%s' must not be a pattern", location));
    }

    Resource[] getResources(String location, ResourceType type) {
        this.validatePattern(location, type);
        String directoryPath = location.substring(0, location.indexOf("*/"));
        String fileName = location.substring(location.lastIndexOf("/") + 1);
        Resource directoryResource = this.getResource(directoryPath);
        if (!directoryResource.exists()) {
            return new Resource[]{directoryResource};
        }
        File directory = this.getDirectory(location, directoryResource);
        File[] subDirectories = directory.listFiles(this::isVisibleDirectory);
        if (subDirectories == null) {
            return EMPTY_RESOURCES;
        }
        Arrays.sort(subDirectories, FILE_PATH_COMPARATOR);
        if (type == ResourceType.DIRECTORY) {
            return (Resource[])Arrays.stream(subDirectories).map(FileSystemResource::new).toArray(Resource[]::new);
        }
        ArrayList resources2 = new ArrayList();
        FilenameFilter filter2 = (dir, name) -> name.equals(fileName);
        for (File subDirectory : subDirectories) {
            File[] files = subDirectory.listFiles(filter2);
            if (files == null) continue;
            Arrays.sort(files, FILE_NAME_COMPARATOR);
            Arrays.stream(files).map(FileSystemResource::new).forEach(resources2::add);
        }
        return resources2.toArray(EMPTY_RESOURCES);
    }

    private void validatePattern(String location, ResourceType type) {
        Assert.state(this.isPattern(location), () -> String.format("Location '%s' must be a pattern", location));
        Assert.state(!location.startsWith("classpath*:"), () -> String.format("Location '%s' cannot use classpath wildcards", location));
        Assert.state(StringUtils.countOccurrencesOf(location, "*") == 1, () -> String.format("Location '%s' cannot contain multiple wildcards", location));
        String directoryPath = type != ResourceType.DIRECTORY ? location.substring(0, location.lastIndexOf("/") + 1) : location;
        Assert.state(directoryPath.endsWith("*/"), () -> String.format("Location '%s' must end with '*/'", location));
    }

    private File getDirectory(String patternLocation, Resource resource) {
        try {
            File directory = resource.getFile();
            Assert.state(directory.isDirectory(), () -> "'" + directory + "' is not a directory");
            return directory;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load config data resource from pattern '" + patternLocation + "'", ex);
        }
    }

    private boolean isVisibleDirectory(File file) {
        return file.isDirectory() && !file.getName().startsWith("..");
    }

    static enum ResourceType {
        FILE,
        DIRECTORY;

    }
}

