/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public final class ConfigData {
    private final List<PropertySource<?>> propertySources;
    private final Set<Option> options;
    public static final ConfigData EMPTY = new ConfigData(Collections.emptySet(), new Option[0]);

    public ConfigData(Collection<? extends PropertySource<?>> propertySources, Option ... options) {
        Assert.notNull(propertySources, "PropertySources must not be null");
        Assert.notNull((Object)options, "Options must not be null");
        this.propertySources = Collections.unmodifiableList(new ArrayList(propertySources));
        this.options = Collections.unmodifiableSet(options.length != 0 ? EnumSet.copyOf(Arrays.asList(options)) : EnumSet.noneOf(Option.class));
    }

    public List<PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public static enum Option {
        IGNORE_IMPORTS,
        IGNORE_PROFILES;

    }
}

