/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.websocket;

import cn.hutool.cache.GlobalPruneTimer;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import com.mugui.bean.JsonBean;
import com.mugui.spring.base.Task;
import com.mugui.spring.base.TaskInterface;
import com.mugui.spring.net.baghandle.NetHandle;
import com.mugui.spring.net.bean.NetBag;
import com.mugui.spring.net.websocket.WebSocketBean;
import com.mugui.spring.net.websocket.WebSocketManager;
import com.mugui.spring.net.websocket.WebSocketMethodConfBean;
import com.mugui.spring.net.websocket.WebSocketSessionManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.websocket.Session;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Task(time=0, value=0)
public final class WebSocketTask
extends HashMap<Integer, ConcurrentHashMap<String, ConcurrentHashMap<Session, NetBag>>>
implements TaskInterface {
    private static final long serialVersionUID = 5595734246734609508L;
    @Autowired
    private NetHandle nethandle;
    @Autowired
    private WebSocketManager webSocketManager;
    private ConcurrentHashMap<String, Session> user_sessions = null;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private final HashMap<String, WebSocketBeanTask> scheduledThreadPoolExecutorMap = new HashMap();
    static final int BIDA = 0;
    static final int NON_BIDA = 1;
    @Autowired
    private WebSocketSessionManager webSocketSessionManager;
    private final ConcurrentHashMap<String, ThreadTask> THREAD_MAP = new ConcurrentHashMap();

    private ConcurrentHashMap<Session, NetBag> getSessionMap(ConcurrentHashMap<String, ConcurrentHashMap<Session, NetBag>> map, WebSocketBean webSocketBean) {
        ConcurrentHashMap<Session, NetBag> concurrentHashMap = map.get(webSocketBean.getValue());
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap();
            map.put(webSocketBean.getValue(), concurrentHashMap);
        }
        return concurrentHashMap;
    }

    private WebSocketBean getWebSocketBean(String key) {
        Object object = this.webSocketManager.get(key);
        if (object == null || !(object instanceof WebSocketBean)) {
            throw new RuntimeException(object + " \u672a\u53d1\u73b0\u7684websocket\u5904\u7406\u5668\uff0c\u5173\u4e8e\uff1a" + key);
        }
        return (WebSocketBean)((Object)object);
    }

    private ConcurrentHashMap<String, ConcurrentHashMap<Session, NetBag>> getMap(int type) {
        ConcurrentHashMap concurrentHashMap2 = (ConcurrentHashMap)this.get(type);
        if (concurrentHashMap2 == null) {
            concurrentHashMap2 = new ConcurrentHashMap();
            this.put(type, concurrentHashMap2);
        }
        return concurrentHashMap2;
    }

    public void sub(Session session, NetBag bag) {
        if (session == null || bag == null || StringUtils.isBlank(bag.getSession())) {
            return;
        }
        Session session2 = this.user_sessions.get(bag.getSession());
        if (session2 != null && !session2.getId().equals(session.getId())) {
            try {
                if (session2.isOpen()) {
                    session2.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.user_sessions.put(bag.getSession(), session);
        WebSocketBean webSocketBean = this.getWebSocketBean(bag.getFunc());
        ConcurrentHashMap<String, ConcurrentHashMap<Session, NetBag>> map = this.getMap(webSocketBean.getType());
        ConcurrentHashMap<Session, NetBag> sessionMap = this.getSessionMap(map, webSocketBean);
        sessionMap.put(session, bag);
        this.createCycleTask(webSocketBean);
    }

    public void unsub(Session session, NetBag bag) {
        WebSocketBean webSocketBean = this.getWebSocketBean(bag.getFunc());
        ConcurrentHashMap<String, ConcurrentHashMap<Session, NetBag>> map = this.getMap(webSocketBean.getType());
        ConcurrentHashMap<Session, NetBag> sessionMap = this.getSessionMap(map, webSocketBean);
        sessionMap.remove(session);
    }

    public void init() {
        System.out.println(WebSocketTask.class.getName() + "\u52a0\u8f7d");
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(10);
        this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        ThreadFactoryBuilder setNamePrefix = ThreadFactoryBuilder.create().setNamePrefix("Webscoket-Scheduled-");
        this.scheduledThreadPoolExecutor.setThreadFactory(setNamePrefix.build());
        this.user_sessions = new ConcurrentHashMap();
        GlobalPruneTimer.INSTANCE.schedule(new Runnable(){

            @Override
            public void run() {
                System.out.println("user_sessions--->>>\u6e05\u7406");
                Iterator iterator = WebSocketTask.this.user_sessions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry next = iterator.next();
                    if (((Session)next.getValue()).isOpen()) continue;
                    String id = ((Session)next.getValue()).getId();
                    ThreadTask remove = (ThreadTask)WebSocketTask.this.THREAD_MAP.remove(id);
                    if (remove != null) {
                        remove.time = 0L;
                    }
                    iterator.remove();
                }
            }
        }, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCycleTask(WebSocketBean webSocketBean) {
        if (webSocketBean.getType() != 0) {
            return;
        }
        Class<WebSocketTask> clazz = WebSocketTask.class;
        synchronized (WebSocketTask.class) {
            if (!this.scheduledThreadPoolExecutorMap.containsKey(webSocketBean.getValue())) {
                this.scheduledThreadPoolExecutorMap.put(webSocketBean.getValue(), new WebSocketBeanTask(webSocketBean, this));
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(this.scheduledThreadPoolExecutorMap.get(webSocketBean.getValue()), webSocketBean.getBlank(), webSocketBean.getBlank(), TimeUnit.MILLISECONDS);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Deprecated
    public void run() {
    }

    private void cycle(WebSocketBean webSocketBean, ConcurrentHashMap<Session, NetBag> hashMap, NetBag bag, String mark, int type) {
        WebSocketMethodConfBean conf = webSocketBean.getConf();
        if (conf != null && conf.getValue() == 1) {
            Iterator<Map.Entry<Session, NetBag>> lIterator = hashMap.entrySet().iterator();
            while (lIterator.hasNext()) {
                Map.Entry<Session, NetBag> next = lIterator.next();
                String udpHandle = null;
                if (bag == null) {
                    udpHandle = this.nethandle.WsHandle((NetBag)NetBag.newBean((JsonBean)next.getValue()));
                } else {
                    next.getValue().setData(bag.getData());
                    udpHandle = this.nethandle.WsHandle((NetBag)NetBag.newBean((JsonBean)next.getValue()));
                }
                if (next.getKey().isOpen()) {
                    this.sendData(next.getKey(), udpHandle, mark, type);
                    continue;
                }
                lIterator.remove();
            }
        } else {
            Iterator<Map.Entry<Session, NetBag>> lIterator = hashMap.entrySet().iterator();
            String udpHandle = null;
            while (lIterator.hasNext()) {
                Map.Entry<Session, NetBag> next = lIterator.next();
                if (udpHandle == null) {
                    if (bag == null) {
                        udpHandle = this.nethandle.WsHandle((NetBag)NetBag.newBean((JsonBean)next.getValue()));
                    } else {
                        next.getValue().setData(bag.getData());
                        udpHandle = this.nethandle.WsHandle((NetBag)NetBag.newBean((JsonBean)next.getValue()));
                    }
                }
                if (next.getKey().isOpen()) {
                    this.sendData(next.getKey(), udpHandle, mark, type);
                    continue;
                }
                lIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendData(Session key, String udpHandle, String mark, int type) {
        boolean add;
        ThreadTask thread = this.THREAD_MAP.get(key.getId());
        if (thread == null) {
            ConcurrentHashMap<String, ThreadTask> concurrentHashMap = this.THREAD_MAP;
            synchronized (concurrentHashMap) {
                if (thread == null) {
                    thread = new ThreadTask(key.getId());
                    this.THREAD_MAP.put(key.getId(), thread);
                    thread.start();
                }
            }
        }
        if (!(add = thread.add(key, udpHandle, mark, type)) && !thread.bool) {
            thread = new ThreadTask(key.getId());
            this.THREAD_MAP.put(key.getId(), thread);
            thread.start();
            add = thread.add(key, udpHandle, mark, type);
        }
    }

    public void triggerAsync(String key) {
        this.triggerAsync(key, null);
    }

    public void triggerBasic(String key) {
        this.triggerBasic(key, null);
    }

    public void triggerAsync(String key, NetBag bag) {
        this.triggerAsync(key, bag, null, 0);
    }

    public void triggerBasic(String key, NetBag bag) {
        this.triggerBasic(key, bag, null, 0);
    }

    public void sendDate(String sessionId, String func) {
        this.sendDate(sessionId, func, null);
    }

    public void sendDate(String sessionId, String func, NetBag bag) {
        this.sendDate(sessionId, func, bag, null, 0);
    }

    public void sendDate(String sessionId, NetBag return_bag) {
        this.sendDate(sessionId, return_bag, null, 1);
    }

    public void sendNonDate(String sessionId, NetBag return_bag, String mark) {
        this.sendDate(sessionId, return_bag, mark, 1);
    }

    public void sendNonDate(String sessionId, String func, NetBag bag, String mark) {
        this.sendDate(sessionId, func, bag, mark, 1);
    }

    public void sendNonDate(String sessionId, String func, String mark) {
        this.sendNonDate(sessionId, func, null, mark);
    }

    public void triggerNonBasic(String key, String mark) {
        this.triggerNonBasic(key, null, mark);
    }

    public void triggerNonBasic(String key, NetBag bag, String mark) {
        this.triggerBasic(key, bag, mark, 1);
    }

    public void triggerNonAsync(String key, String mark) {
        this.triggerNonAsync(key, null, mark);
    }

    public void triggerNonAsync(String key, NetBag bag, String mark) {
        this.triggerAsync(key, bag, mark, 1);
    }

    private void triggerAsync(String key, final NetBag bag, final String mark, final int type) {
        final WebSocketBean webSocketBean = this.getWebSocketBean(key);
        ConcurrentHashMap<String, ConcurrentHashMap<Session, NetBag>> concurrentHashMap = this.getMap(1);
        final ConcurrentHashMap<Session, NetBag> sessionMap = this.getSessionMap(concurrentHashMap, webSocketBean);
        if (sessionMap.isEmpty()) {
            return;
        }
        this.scheduledThreadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                WebSocketTask.this.cycle(webSocketBean, sessionMap, bag, mark, type);
            }
        });
    }

    private void triggerBasic(String key, NetBag bag, String mark, int type) {
        WebSocketBean webSocketBean = this.getWebSocketBean(key);
        ConcurrentHashMap<String, ConcurrentHashMap<Session, NetBag>> concurrentHashMap = this.getMap(1);
        ConcurrentHashMap<Session, NetBag> sessionMap = this.getSessionMap(concurrentHashMap, webSocketBean);
        if (sessionMap.isEmpty()) {
            return;
        }
        this.cycle(webSocketBean, sessionMap, bag, mark, type);
    }

    private void sendDate(String sessionId, String func, NetBag bag, String mark, int type) {
        WebSocketBean webSocketBean = this.getWebSocketBean(func);
        ConcurrentHashMap<String, ConcurrentHashMap<Session, NetBag>> concurrentHashMap = this.getMap(1);
        ConcurrentHashMap<Session, NetBag> sessionMap = this.getSessionMap(concurrentHashMap, webSocketBean);
        if (sessionMap.isEmpty()) {
            return;
        }
        Session session = this.user_sessions.get(sessionId);
        if (session == null) {
            return;
        }
        NetBag netBag = sessionMap.get(session);
        if (netBag == null) {
            return;
        }
        String udpHandle = null;
        if (bag == null) {
            udpHandle = this.nethandle.WsHandle((NetBag)NetBag.newBean((JsonBean)netBag));
        } else {
            netBag.setData(bag.getData());
            udpHandle = this.nethandle.WsHandle((NetBag)NetBag.newBean((JsonBean)netBag));
        }
        this.sendData(session, udpHandle, mark, 1);
    }

    private void sendDate(String sessionId, NetBag return_bag, String mark, int type) {
        Session session = this.user_sessions.get(sessionId);
        if (session == null) {
            return;
        }
        this.sendData(session, return_bag.toString(), mark, 1);
    }

    public ConcurrentHashMap<String, ThreadTask> getTHREAD_MAP() {
        return this.THREAD_MAP;
    }

    final class ThreadTask
    extends Thread {
        private boolean bool = true;
        private ConcurrentHashMap<String, ConcurrentLinkedQueue<TempBean>> map = new ConcurrentHashMap();
        private int lock_mark = 0;
        long time = System.currentTimeMillis();
        private String id = "";

        public ThreadTask(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.setName("WebSocket_ThreadTask");
            block8: while (true) {
                if (!this.bool) {
                    System.out.println("\u5173\u95ed" + this.id);
                    WebSocketTask.this.THREAD_MAP.remove(this.id);
                    this.map.clear();
                    return;
                }
                Iterator<Map.Entry<String, ConcurrentLinkedQueue<TempBean>>> iterator = this.map.entrySet().iterator();
                boolean isbag = false;
                block9: while (true) {
                    if (!iterator.hasNext()) {
                        if (!isbag) {
                            ++this.lock_mark;
                        }
                        if (!this.bool || this.lock_mark == 0) continue block8;
                        ConcurrentHashMap<String, ConcurrentLinkedQueue<TempBean>> concurrentHashMap = this.map;
                        synchronized (concurrentHashMap) {
                            break;
                        }
                    }
                    Map.Entry<String, ConcurrentLinkedQueue<TempBean>> next = iterator.next();
                    ConcurrentLinkedQueue<TempBean> value = next.getValue();
                    while (true) {
                        TempBean poll;
                        if (!this.bool || (poll = value.poll()) == null) continue block9;
                        isbag = true;
                        this.lock_mark = 0;
                        Session key = poll.key;
                        try {
                            if (key.isOpen()) {
                                this.time = System.currentTimeMillis();
                                key.getBasicRemote().sendText(poll.udpHandle);
                                continue;
                            }
                            key.close();
                            WebSocketTask.this.webSocketSessionManager.del(key.getId());
                            this.bool = false;
                            continue block9;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                key.close();
                                WebSocketTask.this.webSocketSessionManager.del(key.getId());
                                this.bool = false;
                                continue block9;
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                                continue;
                            }
                        }
                        break;
                    }
                }
                {
                    while (this.bool && this.lock_mark != 0) {
                        try {
                            this.map.wait(1000L);
                            if (System.currentTimeMillis() - this.time <= 60000L) continue;
                            this.bool = false;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Session key, String udpHandle, String mark, int type) {
            if (this.bool) {
                if (mark == null) {
                    mark = "";
                }
                ConcurrentLinkedQueue<TempBean> concurrentLinkedQueue = this.map.get(mark + "_" + type);
                switch (type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (concurrentLinkedQueue == null || concurrentLinkedQueue.isEmpty()) break;
                        return true;
                    }
                    default: {
                        throw new RuntimeException("type :" + type + "\u9519\u8bef   key:" + key + " udpHandle" + udpHandle + " mark:" + mark);
                    }
                }
                if (concurrentLinkedQueue == null) {
                    concurrentLinkedQueue = new ConcurrentLinkedQueue();
                    this.map.put(mark + "_" + type, concurrentLinkedQueue);
                }
                ConcurrentHashMap<String, ConcurrentLinkedQueue<TempBean>> concurrentHashMap = this.map;
                synchronized (concurrentHashMap) {
                    concurrentLinkedQueue.offer(new TempBean(key, udpHandle));
                    this.lock_mark = 0;
                    this.map.notifyAll();
                }
                return true;
            }
            return false;
        }
    }

    private final class TempBean {
        Session key;
        String udpHandle;

        public TempBean(Session key, String udpHandle) {
            this.key = key;
            this.udpHandle = udpHandle;
        }
    }

    private static class WebSocketBeanTask
    implements Runnable {
        WebSocketBean webSocketBean = null;
        WebSocketTask webSocketTask = null;

        public WebSocketBeanTask(WebSocketBean webSocketBean, WebSocketTask webSocketTask) {
            this.webSocketBean = webSocketBean;
            this.webSocketTask = webSocketTask;
        }

        @Override
        public void run() {
            try {
                ConcurrentHashMap map = this.webSocketTask.getMap(0);
                if (map.isEmpty()) {
                    return;
                }
                ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)map.get(this.webSocketBean.getValue());
                this.webSocketTask.cycle(this.webSocketBean, concurrentHashMap, null, null, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

