/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.websocket;

import com.mugui.spring.net.bean.NetBag;
import com.mugui.spring.net.websocket.WebSocketSessionManager;
import com.mugui.spring.net.websocket.WebSocketTask;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/")
@Component
public class WebHandle {
    private WebSocketSessionManager webSocketSessionManager;
    private WebSocketTask webSocketTask;

    public WebHandle() {
        ApplicationContext app = (ApplicationContext)System.getProperties().get("Application");
        if (app != null) {
            this.webSocketSessionManager = app.getBean(WebSocketSessionManager.class);
            this.webSocketTask = app.getBean(WebSocketTask.class);
        }
    }

    @OnOpen
    public void onOpen(Session session) {
        this.webSocketSessionManager.add(session.getId(), session);
    }

    @OnMessage
    public void onMessage(Session session, byte[] message) {
        NetBag bag = (NetBag)((Object)NetBag.newBean(NetBag.class, (Object)new String(message)));
        if (bag.getFunc().startsWith("sub.")) {
            bag.setFunc(bag.getFunc().substring(4));
            this.webSocketSessionManager.sub(session, bag);
        } else if (bag.getFunc().startsWith("unsub.")) {
            bag.setFunc(bag.getFunc().substring(6));
            this.webSocketSessionManager.unsub(session, bag);
        }
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        NetBag bag = (NetBag)((Object)NetBag.newBean(NetBag.class, (Object)message));
        if (bag.getFunc().startsWith("sub.")) {
            bag.setFunc(bag.getFunc().substring(4));
            this.webSocketSessionManager.sub(session, bag);
        } else if (bag.getFunc().startsWith("unsub.")) {
            bag.setFunc(bag.getFunc().substring(6));
            this.webSocketSessionManager.unsub(session, bag);
        }
    }

    @OnError
    public void onError(Session session, Throwable error) throws Throwable {
        this.webSocketSessionManager.del(session.getId());
        error.printStackTrace();
        WebSocketTask.ThreadTask remove = this.webSocketTask.getTHREAD_MAP().remove(session.getId());
        if (remove != null) {
            remove.time = 0L;
        }
    }

    @OnClose
    public void onClose(Session session) {
        this.webSocketSessionManager.del(session.getId());
        WebSocketTask.ThreadTask remove = this.webSocketTask.getTHREAD_MAP().remove(session.getId());
        if (remove != null) {
            remove.time = 0L;
        }
    }
}

