/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.sys;

import cn.hutool.core.util.StrUtil;
import com.mugui.spring.base.Manager;
import com.mugui.spring.net.sys.SysLogApi;
import com.mugui.spring.net.sys.SysLogImpl;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.stereotype.Component;

@Component
public class SysLogManager
extends Manager<String, SysLogApi> {
    public static final String FORWARD_LOG = "forward_log";
    public static final String DEFAULT_LOG = "default_log";
    public static final String CACHE_LOG = "cache_log";
    public static final String NETBAG_LOG = "netbag_log";
    public static final String FILTER_LOG = "filter_log";
    public static final String LISTENER_LOG = "listener_log";
    public static final String TASK_LOG = "task_log";
    public static final String[] logs = new String[]{"task_log", "forward_log", "default_log", "forward_log", "cache_log", "netbag_log", "listener_log", "filter_log"};

    public SysLogApi getSysLog(String syslogname) {
        try {
            for (String id : logs) {
                if (!id.equals(syslogname)) continue;
                return (SysLogApi)this.invokeFunction(this.toLogName(id), new Object[0]);
            }
            SysLogApi object = (SysLogApi)this.get(syslogname);
            if (object != null) {
                return object;
            }
            return this.initSysLog(syslogname);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysLogApi initSysLog(String syslogname) {
        SysLogApi b = (SysLogApi)this.get(syslogname);
        if (b == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (b == null) {
                    ReferenceConfig reference = new ReferenceConfig();
                    reference.setInterface(SysLogApi.class);
                    reference.setVersion("");
                    reference.setGeneric(true);
                    reference.setGroup(syslogname);
                    GenericService genericService = (GenericService)reference.get();
                    b = new SysLogImpl(genericService);
                    this.add(syslogname, b);
                }
            }
        }
        return b;
    }

    private String toLogName(String id) {
        String[] split = id.split("_");
        String name = "";
        for (String strs : split) {
            name = name + StrUtil.upperFirst(strs);
        }
        return name;
    }

    public SysLogApi ForwardLog() {
        return this.initSysLog(FORWARD_LOG);
    }

    public SysLogApi DefaultLog() {
        return this.initSysLog(DEFAULT_LOG);
    }

    public SysLogApi CacheLog() {
        return this.initSysLog(CACHE_LOG);
    }

    public SysLogApi NetbagLog() {
        return this.initSysLog(NETBAG_LOG);
    }

    public SysLogApi ListenerLog() {
        return this.initSysLog(LISTENER_LOG);
    }

    public SysLogApi FilterLog() {
        return this.initSysLog(FILTER_LOG);
    }

    public SysLogApi TaskLog() {
        return this.initSysLog(TASK_LOG);
    }
}

