/*
 * Decompiled with CFR 0.152.
 */
package com.mugui.spring.net.lock;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.XmlUtil;
import com.mugui.spring.base.ManagerInterface;
import com.mugui.spring.net.auto.AutoManager;
import com.mugui.spring.net.classutil.DataSave;
import com.mugui.spring.net.lock.NetBagGroupLock;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
@AutoManager
public class GroupLockManager
implements ManagerInterface<String, Object> {
    private static HashMap<String, Object> map = null;
    private String name = null;
    private String value = null;

    public void init() {
        this.clear();
        map = new HashMap();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return map.entrySet();
    }

    @Override
    public boolean init(Object object) {
        this.init();
        this.loadByDefaultConfigXml();
        this.loadByClass((Class)object);
        return true;
    }

    private void loadByDefaultConfigXml() {
        ClassPathResource resource = new ClassPathResource("ForwardConfig.xml");
        try {
            Document document = null;
            try {
                document = XmlUtil.readXML(resource.getInputStream());
            }
            catch (Exception e) {
                return;
            }
            NodeList list = document.getChildNodes().item(0).getChildNodes();
            for (int i2 = 0; i2 < list.getLength(); ++i2) {
                Node item = list.item(i2);
                if (!item.getNodeName().equals("net-lock-group")) continue;
                NodeList childNodes = item.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    if (childNodes.item(j).getNodeName().equals("name")) {
                        this.name = childNodes.item(j).getChildNodes().item(0).getNodeValue();
                    }
                    if (!childNodes.item(j).getNodeName().equals("value")) continue;
                    this.value = childNodes.item(j).getChildNodes().item(0).getNodeValue();
                }
                NetBagGroupLock forward = new NetBagGroupLock(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return null;
                    }

                    @Override
                    public String[] value() {
                        return GroupLockManager.this.value.split(".");
                    }

                    @Override
                    public String name() {
                        return GroupLockManager.this.name;
                    }
                };
                if (forward.value() != null) continue;
                for (String key : forward.value()) {
                    this.handleKey(key, forward.name());
                }
            }
        }
        catch (UtilException e) {
            e.printStackTrace();
        }
    }

    private void loadByClass(Class<?> name) {
        for (Class<?> class_name : DataSave.initClassList(name)) {
            NetBagGroupLock filter2;
            if (!class_name.isAnnotationPresent(NetBagGroupLock.class) || (filter2 = class_name.getAnnotation(NetBagGroupLock.class)).value() != null) continue;
            for (String key : filter2.value()) {
                this.handleKey(key, filter2.name());
            }
        }
    }

    private void handleKey(String key, String value) {
        String[] keys = key.split("[.]");
        HashMap<String, Object> tempmap = map;
        for (String temp : keys) {
            temp = temp.trim();
            HashMap<String, Object> t = null;
            t = (HashMap<String, Object>)tempmap.get(temp);
            if (t == null) {
                t = new HashMap<String, Object>();
                tempmap.put(temp, t);
            }
            tempmap = t;
        }
        tempmap.put("&&", value);
    }

    @Override
    public boolean clear() {
        if (map != null) {
            map.clear();
        }
        return false;
    }

    @Override
    public boolean is(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return !map.isEmpty() && map.get(name) != null;
    }

    @Override
    public Object del(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return map.remove(name);
    }

    @Override
    public Object get(String name) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        HashMap tempmap = map;
        for (String key : name.split("[.]")) {
            HashMap temp = (HashMap)tempmap.get(key);
            if (temp == null) {
                temp = (HashMap)tempmap.get("*");
            }
            if (temp == null) {
                return null;
            }
            tempmap = temp;
            if (tempmap.size() == 1 && temp.containsKey("&&")) break;
        }
        return tempmap.get("&&");
    }

    @Override
    public boolean add(String name, Object object) {
        if (map == null) {
            throw new NullPointerException("please run init");
        }
        return true;
    }

    @Override
    public boolean isInit() {
        return false;
    }
}

