/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.reader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.poi.excel.reader.AbstractSheetReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;

public class ListSheetReader
extends AbstractSheetReader<List<List<Object>>> {
    private final boolean aliasFirstLine;

    public ListSheetReader(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        super(startRowIndex, endRowIndex);
        this.aliasFirstLine = aliasFirstLine;
    }

    @Override
    public List<List<Object>> read(Sheet sheet) {
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        int startRowIndex = Math.max(this.startRowIndex, sheet.getFirstRowNum());
        int endRowIndex = Math.min(this.endRowIndex, sheet.getLastRowNum());
        for (int i2 = startRowIndex; i2 <= endRowIndex; ++i2) {
            List<Object> rowList = this.readRow(sheet, i2);
            if (!CollUtil.isNotEmpty(rowList) && this.ignoreEmptyRow) continue;
            if (this.aliasFirstLine && i2 == startRowIndex) {
                rowList = Convert.toList(Object.class, this.aliasHeader(rowList));
            }
            resultList.add(rowList);
        }
        return resultList;
    }
}

