/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.compress.extractor;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.extra.compress.extractor.Extractor;
import cn.hutool.extra.compress.extractor.Seven7EntryInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;

public class SenvenZExtractor
implements Extractor {
    private final SevenZFile sevenZFile;

    public SenvenZExtractor(File file) {
        this(file, null);
    }

    public SenvenZExtractor(File file, char[] password) {
        try {
            this.sevenZFile = new SevenZFile(file, password);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public SenvenZExtractor(InputStream in) {
        this(in, null);
    }

    public SenvenZExtractor(InputStream in, char[] password) {
        this((SeekableByteChannel)new SeekableInMemoryByteChannel(IoUtil.readBytes(in)), password);
    }

    public SenvenZExtractor(SeekableByteChannel channel) {
        this(channel, null);
    }

    public SenvenZExtractor(SeekableByteChannel channel, char[] password) {
        try {
            this.sevenZFile = new SevenZFile(channel, password);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void extract(File targetDir, Filter<ArchiveEntry> filter2) {
        try {
            this.extractInternal(targetDir, filter2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.close();
        }
    }

    private void extractInternal(File targetDir, Filter<ArchiveEntry> filter2) throws IOException {
        SevenZArchiveEntry entry;
        Assert.isTrue(null != targetDir && (false == targetDir.exists() || targetDir.isDirectory()), "target must be dir.", new Object[0]);
        SevenZFile sevenZFile = this.sevenZFile;
        while (null != (entry = this.sevenZFile.getNextEntry())) {
            File outItemFile = FileUtil.file(targetDir, entry.getName());
            if (entry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            if (entry.hasStream()) {
                FileUtil.writeFromStream((InputStream)new Seven7EntryInputStream(sevenZFile, entry), outItemFile);
                continue;
            }
            FileUtil.touch(outItemFile);
        }
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.sevenZFile);
    }
}

