/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.lang.Assert;
import java.util.Comparator;

public class InstanceComparator<T>
implements Comparator<T> {
    private final boolean atEndIfMiss;
    private final Class<?>[] instanceOrder;

    public InstanceComparator(Class<?> ... instanceOrder) {
        this(false, instanceOrder);
    }

    public InstanceComparator(boolean atEndIfMiss, Class<?> ... instanceOrder) {
        Assert.notNull(instanceOrder, "'instanceOrder' array must not be null", new Object[0]);
        this.atEndIfMiss = atEndIfMiss;
        this.instanceOrder = instanceOrder;
    }

    @Override
    public int compare(T o1, T o2) {
        int i1 = this.getOrder(o1);
        int i2 = this.getOrder(o2);
        return Integer.compare(i1, i2);
    }

    private int getOrder(T object) {
        if (object != null) {
            for (int i2 = 0; i2 < this.instanceOrder.length; ++i2) {
                if (!this.instanceOrder[i2].isInstance(object)) continue;
                return i2;
            }
        }
        return this.atEndIfMiss ? this.instanceOrder.length : -1;
    }
}

