/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.io.UnsupportedEncodingException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public final class SafeEncoder {
    private SafeEncoder() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static byte[][] encodeMany(String ... strs) {
        byte[][] many = new byte[strs.length][];
        for (int i2 = 0; i2 < strs.length; ++i2) {
            many[i2] = SafeEncoder.encode(strs[i2]);
        }
        return many;
    }

    public static byte[] encode(String str) {
        try {
            if (str == null) {
                throw new JedisDataException("value sent to redis cannot be null");
            }
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JedisException(e);
        }
    }

    public static String encode(byte[] data) {
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JedisException(e);
        }
    }
}

