/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.time.Duration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.session.Session;

class HttpSessionAdapter<S extends Session>
implements HttpSession {
    private static final Log logger = LogFactory.getLog(HttpSessionAdapter.class);
    private S session;
    private final ServletContext servletContext;
    private boolean invalidated;
    private boolean old;
    private static final HttpSessionContext NOOP_SESSION_CONTEXT = new HttpSessionContext(){

        @Override
        public HttpSession getSession(String sessionId) {
            return null;
        }

        @Override
        public Enumeration<String> getIds() {
            return EMPTY_ENUMERATION;
        }
    };
    private static final Enumeration<String> EMPTY_ENUMERATION = new Enumeration<String>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            throw new NoSuchElementException("a");
        }
    };

    HttpSessionAdapter(S session, ServletContext servletContext) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext cannot be null");
        }
        this.session = session;
        this.servletContext = servletContext;
    }

    S getSession() {
        return this.session;
    }

    @Override
    public long getCreationTime() {
        this.checkState();
        return this.session.getCreationTime().toEpochMilli();
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public long getLastAccessedTime() {
        this.checkState();
        return this.session.getLastAccessedTime().toEpochMilli();
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(Duration.ofSeconds(interval));
    }

    @Override
    public int getMaxInactiveInterval() {
        return (int)this.session.getMaxInactiveInterval().getSeconds();
    }

    @Override
    public HttpSessionContext getSessionContext() {
        return NOOP_SESSION_CONTEXT;
    }

    @Override
    public Object getAttribute(String name) {
        this.checkState();
        return this.session.getAttribute(name);
    }

    @Override
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        this.checkState();
        return Collections.enumeration(this.session.getAttributeNames());
    }

    @Override
    public String[] getValueNames() {
        this.checkState();
        Set<String> attrs = this.session.getAttributeNames();
        return attrs.toArray(new String[0]);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.checkState();
        Object oldValue = this.session.getAttribute(name);
        this.session.setAttribute(name, value);
        if (value != oldValue) {
            if (oldValue instanceof HttpSessionBindingListener) {
                try {
                    ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent(this, name, oldValue));
                }
                catch (Throwable th) {
                    logger.error("Error invoking session binding event listener", th);
                }
            }
            if (value instanceof HttpSessionBindingListener) {
                try {
                    ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(this, name, value));
                }
                catch (Throwable th) {
                    logger.error("Error invoking session binding event listener", th);
                }
            }
        }
    }

    @Override
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.checkState();
        Object oldValue = this.session.getAttribute(name);
        this.session.removeAttribute(name);
        if (oldValue instanceof HttpSessionBindingListener) {
            try {
                ((HttpSessionBindingListener)oldValue).valueUnbound(new HttpSessionBindingEvent(this, name, oldValue));
            }
            catch (Throwable th) {
                logger.error("Error invoking session binding event listener", th);
            }
        }
    }

    @Override
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    @Override
    public void invalidate() {
        this.checkState();
        this.invalidated = true;
    }

    @Override
    public boolean isNew() {
        this.checkState();
        return !this.old;
    }

    void markNotNew() {
        this.old = true;
    }

    private void checkState() {
        if (this.invalidated) {
            throw new IllegalStateException("The HttpSession has already be invalidated.");
        }
    }
}

