/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.broker.AbstractSubscriptionRegistry;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class DefaultSubscriptionRegistry
extends AbstractSubscriptionRegistry {
    public static final int DEFAULT_CACHE_LIMIT = 1024;
    private static final EvaluationContext messageEvalContext = SimpleEvaluationContext.forPropertyAccessors(new SimpMessageHeaderPropertyAccessor()).build();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private volatile int cacheLimit = 1024;
    @Nullable
    private String selectorHeaderName = "selector";
    private volatile boolean selectorHeaderInUse = false;
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    private final DestinationCache destinationCache = new DestinationCache();
    private final SessionSubscriptionRegistry subscriptionRegistry = new SessionSubscriptionRegistry();

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setSelectorHeaderName(@Nullable String selectorHeaderName) {
        this.selectorHeaderName = StringUtils.hasText(selectorHeaderName) ? selectorHeaderName : null;
    }

    @Nullable
    public String getSelectorHeaderName() {
        return this.selectorHeaderName;
    }

    @Override
    protected void addSubscriptionInternal(String sessionId, String subsId, String destination, Message<?> message) {
        Expression expression = this.getSelectorExpression(message.getHeaders());
        this.subscriptionRegistry.addSubscription(sessionId, subsId, destination, expression);
        this.destinationCache.updateAfterNewSubscription(destination, sessionId, subsId);
    }

    @Nullable
    private Expression getSelectorExpression(MessageHeaders headers) {
        Expression expression;
        block4: {
            String selector;
            expression = null;
            if (this.getSelectorHeaderName() != null && (selector = SimpMessageHeaderAccessor.getFirstNativeHeader(this.getSelectorHeaderName(), headers)) != null) {
                try {
                    expression = this.expressionParser.parseExpression(selector);
                    this.selectorHeaderInUse = true;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Subscription selector: [" + selector + "]");
                    }
                }
                catch (Throwable ex) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug("Failed to parse selector: " + selector, ex);
                }
            }
        }
        return expression;
    }

    @Override
    protected void removeSubscriptionInternal(String sessionId, String subsId, Message<?> message) {
        String destination;
        SessionSubscriptionInfo info = this.subscriptionRegistry.getSubscriptions(sessionId);
        if (info != null && (destination = info.removeSubscription(subsId)) != null) {
            this.destinationCache.updateAfterRemovedSubscription(sessionId, subsId);
        }
    }

    @Override
    public void unregisterAllSubscriptions(String sessionId) {
        SessionSubscriptionInfo info = this.subscriptionRegistry.removeSubscriptions(sessionId);
        if (info != null) {
            this.destinationCache.updateAfterRemovedSession(info);
        }
    }

    @Override
    protected MultiValueMap<String, String> findSubscriptionsInternal(String destination, Message<?> message) {
        LinkedMultiValueMap<String, String> result = this.destinationCache.getSubscriptions(destination, message);
        return this.filterSubscriptions(result, message);
    }

    private MultiValueMap<String, String> filterSubscriptions(MultiValueMap<String, String> allMatches, Message<?> message) {
        if (!this.selectorHeaderInUse) {
            return allMatches;
        }
        LinkedMultiValueMap<String, String> result = new LinkedMultiValueMap<String, String>(allMatches.size());
        allMatches.forEach((sessionId, subIds) -> {
            for (String subId : subIds) {
                Subscription sub;
                SessionSubscriptionInfo info = this.subscriptionRegistry.getSubscriptions((String)sessionId);
                if (info == null || (sub = info.getSubscription(subId)) == null) continue;
                Expression expression = sub.getSelectorExpression();
                if (expression == null) {
                    result.add((String)sessionId, subId);
                    continue;
                }
                try {
                    if (!Boolean.TRUE.equals(expression.getValue(messageEvalContext, message, Boolean.class))) continue;
                    result.add((String)sessionId, subId);
                }
                catch (SpelEvaluationException ex) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Failed to evaluate selector: " + ex.getMessage());
                }
                catch (Throwable ex) {
                    this.logger.debug("Failed to evaluate selector", ex);
                }
            }
        });
        return result;
    }

    public String toString() {
        return "DefaultSubscriptionRegistry[" + this.destinationCache + ", " + this.subscriptionRegistry + "]";
    }

    private static class SimpMessageHeaderPropertyAccessor
    implements PropertyAccessor {
        private SimpMessageHeaderPropertyAccessor() {
        }

        @Override
        public Class<?>[] getSpecificTargetClasses() {
            return new Class[]{Message.class, MessageHeaders.class};
        }

        @Override
        public boolean canRead(EvaluationContext context, @Nullable Object target, String name) {
            return true;
        }

        @Override
        public TypedValue read(EvaluationContext context, @Nullable Object target, String name) {
            Object value;
            if (target instanceof Message) {
                value = name.equals("headers") ? ((Message)target).getHeaders() : null;
            } else if (target instanceof MessageHeaders) {
                MessageHeaders headers = (MessageHeaders)target;
                SimpMessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(headers, SimpMessageHeaderAccessor.class);
                Assert.state(accessor != null, "No SimpMessageHeaderAccessor");
                if ("destination".equalsIgnoreCase(name)) {
                    value = accessor.getDestination();
                } else {
                    value = accessor.getFirstNativeHeader(name);
                    if (value == null) {
                        value = headers.get(name);
                    }
                }
            } else {
                throw new IllegalStateException("Expected Message or MessageHeaders.");
            }
            return new TypedValue(value);
        }

        @Override
        public boolean canWrite(EvaluationContext context, @Nullable Object target, String name) {
            return false;
        }

        @Override
        public void write(EvaluationContext context, @Nullable Object target, String name, @Nullable Object value) {
        }
    }

    private static final class Subscription {
        private final String id;
        @Nullable
        private final Expression selectorExpression;

        public Subscription(String id, @Nullable Expression selector) {
            Assert.notNull((Object)id, "Subscription id must not be null");
            this.id = id;
            this.selectorExpression = selector;
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public Expression getSelectorExpression() {
            return this.selectorExpression;
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof Subscription && this.id.equals(((Subscription)other).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "subscription(id=" + this.id + ")";
        }
    }

    private static class SessionSubscriptionInfo {
        private final String sessionId;
        private final Map<String, Set<Subscription>> destinationLookup = new ConcurrentHashMap<String, Set<Subscription>>(4);

        public SessionSubscriptionInfo(String sessionId) {
            Assert.notNull((Object)sessionId, "'sessionId' must not be null");
            this.sessionId = sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Set<String> getDestinations() {
            return this.destinationLookup.keySet();
        }

        public Set<Subscription> getSubscriptions(String destination) {
            return this.destinationLookup.get(destination);
        }

        @Nullable
        public Subscription getSubscription(String subscriptionId) {
            for (Map.Entry<String, Set<Subscription>> destinationEntry : this.destinationLookup.entrySet()) {
                for (Subscription sub : destinationEntry.getValue()) {
                    if (!sub.getId().equalsIgnoreCase(subscriptionId)) continue;
                    return sub;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubscription(String destination, String subscriptionId, @Nullable Expression selectorExpression) {
            Set<Subscription> subs = this.destinationLookup.get(destination);
            if (subs == null) {
                Map<String, Set<Subscription>> map = this.destinationLookup;
                synchronized (map) {
                    subs = this.destinationLookup.get(destination);
                    if (subs == null) {
                        subs = new CopyOnWriteArraySet<Subscription>();
                        this.destinationLookup.put(destination, subs);
                    }
                }
            }
            subs.add(new Subscription(subscriptionId, selectorExpression));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public String removeSubscription(String subscriptionId) {
            for (Map.Entry<String, Set<Subscription>> destinationEntry : this.destinationLookup.entrySet()) {
                Set<Subscription> subs = destinationEntry.getValue();
                if (subs == null) continue;
                for (Subscription sub : subs) {
                    if (!sub.getId().equals(subscriptionId) || !subs.remove(sub)) continue;
                    Map<String, Set<Subscription>> map = this.destinationLookup;
                    synchronized (map) {
                        if (subs.isEmpty()) {
                            this.destinationLookup.remove(destinationEntry.getKey());
                        }
                    }
                    return destinationEntry.getKey();
                }
            }
            return null;
        }

        public String toString() {
            return "[sessionId=" + this.sessionId + ", subscriptions=" + this.destinationLookup + "]";
        }
    }

    private static class SessionSubscriptionRegistry {
        private final ConcurrentMap<String, SessionSubscriptionInfo> sessions = new ConcurrentHashMap<String, SessionSubscriptionInfo>();

        private SessionSubscriptionRegistry() {
        }

        @Nullable
        public SessionSubscriptionInfo getSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.get(sessionId);
        }

        public Collection<SessionSubscriptionInfo> getAllSubscriptions() {
            return this.sessions.values();
        }

        public SessionSubscriptionInfo addSubscription(String sessionId, String subscriptionId, String destination, @Nullable Expression selectorExpression) {
            SessionSubscriptionInfo value;
            SessionSubscriptionInfo info = (SessionSubscriptionInfo)this.sessions.get(sessionId);
            if (info == null && (value = this.sessions.putIfAbsent(sessionId, info = new SessionSubscriptionInfo(sessionId))) != null) {
                info = value;
            }
            info.addSubscription(destination, subscriptionId, selectorExpression);
            return info;
        }

        @Nullable
        public SessionSubscriptionInfo removeSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.remove(sessionId);
        }

        public String toString() {
            return "registry[" + this.sessions.size() + " sessions]";
        }
    }

    private class DestinationCache {
        private final Map<String, LinkedMultiValueMap<String, String>> accessCache = new ConcurrentHashMap<String, LinkedMultiValueMap<String, String>>(1024);
        private final Map<String, LinkedMultiValueMap<String, String>> updateCache = new LinkedHashMap<String, LinkedMultiValueMap<String, String>>(1024, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, LinkedMultiValueMap<String, String>> eldest) {
                if (this.size() > DefaultSubscriptionRegistry.this.getCacheLimit()) {
                    DestinationCache.this.accessCache.remove(eldest.getKey());
                    return true;
                }
                return false;
            }
        };

        private DestinationCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkedMultiValueMap<String, String> getSubscriptions(String destination, Message<?> message) {
            LinkedMultiValueMap<String, String> result = this.accessCache.get(destination);
            if (result == null) {
                Map<String, LinkedMultiValueMap<String, String>> map = this.updateCache;
                synchronized (map) {
                    result = new LinkedMultiValueMap();
                    for (SessionSubscriptionInfo info : DefaultSubscriptionRegistry.this.subscriptionRegistry.getAllSubscriptions()) {
                        for (String destinationPattern : info.getDestinations()) {
                            if (!DefaultSubscriptionRegistry.this.getPathMatcher().match(destinationPattern, destination)) continue;
                            for (Subscription sub : info.getSubscriptions(destinationPattern)) {
                                result.add(info.sessionId, sub.getId());
                            }
                        }
                    }
                    if (!result.isEmpty()) {
                        this.updateCache.put(destination, result.deepCopy());
                        this.accessCache.put(destination, result);
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterNewSubscription(String destination, String sessionId, String subsId) {
            Map<String, LinkedMultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                this.updateCache.forEach((cachedDestination, subscriptions) -> {
                    Object subsForSession;
                    if (DefaultSubscriptionRegistry.this.getPathMatcher().match(destination, (String)cachedDestination) && ((subsForSession = subscriptions.get(sessionId)) == null || !subsForSession.contains(subsId))) {
                        subscriptions.add(sessionId, subsId);
                        this.accessCache.put((String)cachedDestination, subscriptions.deepCopy());
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterRemovedSubscription(String sessionId, String subsId) {
            Map<String, LinkedMultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                HashSet destinationsToRemove = new HashSet();
                this.updateCache.forEach((destination, sessionMap) -> {
                    Object subscriptions = sessionMap.get(sessionId);
                    if (subscriptions != null) {
                        subscriptions.remove(subsId);
                        if (subscriptions.isEmpty()) {
                            sessionMap.remove(sessionId);
                        }
                        if (sessionMap.isEmpty()) {
                            destinationsToRemove.add(destination);
                        } else {
                            this.accessCache.put((String)destination, sessionMap.deepCopy());
                        }
                    }
                });
                for (String destination2 : destinationsToRemove) {
                    this.updateCache.remove(destination2);
                    this.accessCache.remove(destination2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterRemovedSession(SessionSubscriptionInfo info) {
            Map<String, LinkedMultiValueMap<String, String>> map = this.updateCache;
            synchronized (map) {
                HashSet destinationsToRemove = new HashSet();
                this.updateCache.forEach((destination, sessionMap) -> {
                    if (sessionMap.remove(info.getSessionId()) != null) {
                        if (sessionMap.isEmpty()) {
                            destinationsToRemove.add(destination);
                        } else {
                            this.accessCache.put((String)destination, sessionMap.deepCopy());
                        }
                    }
                });
                for (String destination2 : destinationsToRemove) {
                    this.updateCache.remove(destination2);
                    this.accessCache.remove(destination2);
                }
            }
        }

        public String toString() {
            return "cache[" + this.accessCache.size() + " destination(s)]";
        }
    }
}

