/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.Payload;
import io.rsocket.util.ByteBufPayload;
import io.rsocket.util.DefaultPayload;
import java.nio.ByteBuffer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;

public abstract class PayloadUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataBuffer retainDataAndReleasePayload(Payload payload, DataBufferFactory bufferFactory) {
        try {
            if (bufferFactory instanceof NettyDataBufferFactory) {
                ByteBuf byteBuf = payload.sliceData().retain();
                NettyDataBuffer nettyDataBuffer = ((NettyDataBufferFactory)bufferFactory).wrap(byteBuf);
                return nettyDataBuffer;
            }
            DataBuffer dataBuffer = bufferFactory.wrap(payload.getData());
            return dataBuffer;
        }
        finally {
            if (payload.refCnt() > 0) {
                payload.release();
            }
        }
    }

    public static Payload createPayload(DataBuffer data, DataBuffer metadata) {
        return data instanceof NettyDataBuffer || metadata instanceof NettyDataBuffer ? ByteBufPayload.create((ByteBuf)PayloadUtils.asByteBuf(data), (ByteBuf)PayloadUtils.asByteBuf(metadata)) : DefaultPayload.create((ByteBuffer)PayloadUtils.asByteBuffer(data), (ByteBuffer)PayloadUtils.asByteBuffer(metadata));
    }

    public static Payload createPayload(DataBuffer data) {
        return data instanceof NettyDataBuffer ? ByteBufPayload.create((ByteBuf)PayloadUtils.asByteBuf(data)) : DefaultPayload.create((ByteBuffer)PayloadUtils.asByteBuffer(data));
    }

    static ByteBuf asByteBuf(DataBuffer buffer) {
        return buffer instanceof NettyDataBuffer ? ((NettyDataBuffer)buffer).getNativeBuffer() : Unpooled.wrappedBuffer(buffer.asByteBuffer());
    }

    private static ByteBuffer asByteBuffer(DataBuffer buffer) {
        return buffer instanceof DefaultDataBuffer ? ((DefaultDataBuffer)buffer).getNativeBuffer() : buffer.asByteBuffer();
    }
}

