/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.ByteBuffer;
import org.springframework.data.redis.serializer.DefaultRedisElementReader;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@FunctionalInterface
public interface RedisElementReader<T> {
    @Nullable
    public T read(ByteBuffer var1);

    public static <T> RedisElementReader<T> from(RedisSerializer<T> serializer) {
        Assert.notNull(serializer, "Serializer must not be null!");
        return new DefaultRedisElementReader<T>(serializer);
    }
}

