/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisOperationChain {
    private final Set<PathAndValue> sismember = new LinkedHashSet<PathAndValue>();
    private final Set<PathAndValue> orSismember = new LinkedHashSet<PathAndValue>();
    @Nullable
    private NearPath near;

    public boolean isEmpty() {
        return this.near == null && this.sismember.isEmpty() && this.orSismember.isEmpty();
    }

    public void sismember(String path, Object value) {
        this.sismember(new PathAndValue(path, value));
    }

    public void sismember(PathAndValue pathAndValue) {
        this.sismember.add(pathAndValue);
    }

    public Set<PathAndValue> getSismember() {
        return this.sismember;
    }

    public void orSismember(String path, Object value) {
        this.orSismember(new PathAndValue(path, value));
    }

    public void orSismember(PathAndValue pathAndValue) {
        this.orSismember.add(pathAndValue);
    }

    public void orSismember(Collection<PathAndValue> next) {
        this.orSismember.addAll(next);
    }

    public Set<PathAndValue> getOrSismember() {
        return this.orSismember;
    }

    public void near(NearPath near) {
        Assert.notNull((Object)near, "Near must not be null!");
        this.near = near;
    }

    @Nullable
    public NearPath getNear() {
        return this.near;
    }

    public static class NearPath
    extends PathAndValue {
        public NearPath(String path, Point point, Distance distance) {
            super(path, Arrays.asList(point, distance));
        }

        public Point getPoint() {
            return (Point)this.getFirstValue();
        }

        public Distance getDistance() {
            Iterator<Object> it = this.values().iterator();
            it.next();
            return (Distance)it.next();
        }
    }

    public static class PathAndValue {
        private final String path;
        private final Collection<Object> values;

        public PathAndValue(String path, Object singleValue) {
            this.path = path;
            this.values = Collections.singleton(singleValue);
        }

        public PathAndValue(String path, @Nullable Collection<Object> values) {
            this.path = path;
            this.values = values != null ? values : Collections.emptySet();
        }

        public boolean isSingleValue() {
            return this.values.size() == 1;
        }

        public String getPath() {
            return this.path;
        }

        public Collection<Object> values() {
            return this.values;
        }

        @Nullable
        public Object getFirstValue() {
            return this.values.isEmpty() ? null : this.values.iterator().next();
        }

        public String toString() {
            return this.path + ":" + (this.isSingleValue() ? this.getFirstValue() : this.values);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathAndValue)) {
                return false;
            }
            PathAndValue other = (PathAndValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Collection<Object> this$values = this.values;
            Collection<Object> other$values = other.values;
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PathAndValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Collection<Object> $values = this.values;
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }
    }
}

