/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class ScanOptions {
    public static ScanOptions NONE = new ScanOptions(null, null);
    @Nullable
    private final Long count;
    @Nullable
    private final String pattern;

    private ScanOptions(@Nullable Long count, @Nullable String pattern) {
        this.count = count;
        this.pattern = pattern;
    }

    public static ScanOptionsBuilder scanOptions() {
        return new ScanOptionsBuilder();
    }

    @Nullable
    public Long getCount() {
        return this.count;
    }

    @Nullable
    public String getPattern() {
        return this.pattern;
    }

    public String toOptionString() {
        if (this.equals(NONE)) {
            return "";
        }
        String params = "";
        if (this.count != null) {
            params = params + ", 'count', " + this.count;
        }
        if (StringUtils.hasText(this.pattern)) {
            params = params + ", 'match' , '" + this.pattern + "'";
        }
        return params;
    }

    public static class ScanOptionsBuilder {
        @Nullable
        private Long count;
        @Nullable
        private String pattern;

        public ScanOptionsBuilder count(long count) {
            this.count = count;
            return this;
        }

        public ScanOptionsBuilder match(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public ScanOptions build() {
            return new ScanOptions(this.count, this.pattern);
        }
    }
}

