/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.time.Duration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class StreamReadOptions {
    private static final StreamReadOptions EMPTY = new StreamReadOptions(null, null, false);
    @Nullable
    private final Long block;
    @Nullable
    private final Long count;
    private final boolean noack;

    private StreamReadOptions(@Nullable Long block, @Nullable Long count, boolean noack) {
        this.block = block;
        this.count = count;
        this.noack = noack;
    }

    public static StreamReadOptions empty() {
        return EMPTY;
    }

    public StreamReadOptions noack() {
        return new StreamReadOptions(this.block, this.count, true);
    }

    public StreamReadOptions block(Duration timeout) {
        Assert.notNull((Object)timeout, "Block timeout must not be null!");
        Assert.isTrue(!timeout.isNegative(), "Block timeout must not be negative!");
        return new StreamReadOptions(timeout.toMillis(), this.count, this.noack);
    }

    public StreamReadOptions count(long count) {
        Assert.isTrue(count > 0L, "Count must be greater or equal to zero!");
        return new StreamReadOptions(this.block, count, this.noack);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamReadOptions)) {
            return false;
        }
        StreamReadOptions other = (StreamReadOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$block = this.getBlock();
        Long other$block = other.getBlock();
        if (this$block == null ? other$block != null : !((Object)this$block).equals(other$block)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        return this.isNoack() == other.isNoack();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamReadOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : ((Object)$block).hashCode());
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        result = result * 59 + (this.isNoack() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "StreamReadOptions(block=" + this.getBlock() + ", count=" + this.getCount() + ", noack=" + this.isNoack() + ")";
    }

    @Nullable
    public Long getBlock() {
        return this.block;
    }

    @Nullable
    public Long getCount() {
        return this.count;
    }

    public boolean isNoack() {
        return this.noack;
    }
}

