/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceZSetCommands
implements RedisZSetCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zadd(key, score, value), LettuceConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zadd(key, score, value), LettuceConverters.longToBoolean()));
                return null;
            }
            return LettuceConverters.toBoolean(this.getConnection().zadd(key, score, value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(tuples, "Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zadd(key, LettuceConverters.toObjects(tuples).toArray())));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zadd(key, LettuceConverters.toObjects(tuples).toArray())));
                return null;
            }
            return this.getConnection().zadd(key, LettuceConverters.toObjects(tuples).toArray());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)values, "Values must not be null!");
        Assert.noNullElements((Object[])values, "Values must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrem(key, (V[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrem(key, (V[])values)));
                return null;
            }
            return this.getConnection().zrem(key, (V[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zincrby(key, increment, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zincrby(key, increment, value)));
                return null;
            }
            return this.getConnection().zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrank(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrank(key, value)));
                return null;
            }
            return this.getConnection().zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrank(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrank(key, value)));
                return null;
            }
            return this.getConnection().zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrange(key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrange(key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrange(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangeWithScores(key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangeWithScores(key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)range, "Range for ZRANGEBYSCOREWITHSCORES must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscoreWithScores(key, LettuceConverters.toRange(range)), LettuceConverters.scoredValuesToTupleSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscoreWithScores(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.scoredValuesToTupleSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscoreWithScores(key, LettuceConverters.toRange(range)), LettuceConverters.scoredValuesToTupleSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscoreWithScores(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.scoredValuesToTupleSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.toTupleSet(this.getConnection().zrangebyscoreWithScores(key, LettuceConverters.toRange(range)));
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrangebyscoreWithScores(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrange(key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrange(key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrevrange(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangeWithScores(key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangeWithScores(key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrevrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)range, "Range for ZREVRANGEBYSCORE must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscore(key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscore(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscore(key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscore(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.toBytesSet(this.getConnection().zrevrangebyscore(key, LettuceConverters.toRange(range)));
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrevrangebyscore(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)range, "Range for ZREVRANGEBYSCOREWITHSCORES must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores(key, LettuceConverters.toRange(range)), LettuceConverters.scoredValuesToTupleSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.scoredValuesToTupleSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores(key, LettuceConverters.toRange(range)), LettuceConverters.scoredValuesToTupleSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.scoredValuesToTupleSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.toTupleSet(this.getConnection().zrevrangebyscoreWithScores(key, LettuceConverters.toRange(range)));
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrevrangebyscoreWithScores(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zcount(key, LettuceConverters.toRange(range))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zcount(key, LettuceConverters.toRange(range))));
                return null;
            }
            return this.getConnection().zcount(key, LettuceConverters.toRange(range));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zcard(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zcard(key)));
                return null;
            }
            return this.getConnection().zcard(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zscore(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zscore(key, value)));
                return null;
            }
            return this.getConnection().zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zremrangebyrank(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zremrangebyrank(key, start, end)));
                return null;
            }
            return this.getConnection().zremrangebyrank(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)range, "Range for ZREMRANGEBYSCORE must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zremrangebyscore(key, LettuceConverters.toRange(range))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zremrangebyscore(key, LettuceConverters.toRange(range))));
                return null;
            }
            return this.getConnection().zremrangebyscore(key, LettuceConverters.toRange(range));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null!");
        Assert.notNull((Object)sets, "Source sets must not be null!");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements!");
        Assert.isTrue(weights.size() == sets.length, () -> String.format("The number of weights (%d) must match the number of source sets (%d)!", weights.size(), sets.length));
        ZStoreArgs storeArgs = LettuceZSetCommands.zStoreArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zunionstore(destKey, storeArgs, (K[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zunionstore(destKey, storeArgs, (K[])sets)));
                return null;
            }
            return this.getConnection().zunionstore(destKey, storeArgs, (K[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null!");
        Assert.notNull((Object)sets, "Source sets must not be null!");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zunionstore(destKey, (byte[][])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zunionstore(destKey, (byte[][])sets)));
                return null;
            }
            return this.getConnection().zunionstore(destKey, (byte[][])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null!");
        Assert.notNull((Object)sets, "Source sets must not be null!");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements!");
        Assert.isTrue(weights.size() == sets.length, () -> String.format("The number of weights (%d) must match the number of source sets (%d)!", weights.size(), sets.length));
        ZStoreArgs storeArgs = LettuceZSetCommands.zStoreArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zinterstore(destKey, storeArgs, (K[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zinterstore(destKey, storeArgs, (K[])sets)));
                return null;
            }
            return this.getConnection().zinterstore(destKey, storeArgs, (K[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, "Destination key must not be null!");
        Assert.notNull((Object)sets, "Source sets must not be null!");
        Assert.noNullElements((Object[])sets, "Source sets must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zinterstore(destKey, (byte[][])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zinterstore(destKey, (byte[][])sets)));
                return null;
            }
            return this.getConnection().zinterstore(destKey, (byte[][])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, 0L, options);
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, "Key must not be null!");
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, cursorId, options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (LettuceZSetCommands.this.isQueueing() || LettuceZSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanCursor scanCursor = LettuceZSetCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                ScoredValueScanCursor scoredValueScanCursor = LettuceZSetCommands.this.getConnection().zscan(key, scanCursor, scanArgs);
                String nextCursorId = scoredValueScanCursor.getCursor();
                List result = scoredValueScanCursor.getValues();
                List values = (List)LettuceZSetCommands.this.connection.failsafeReadScanValues(result, LettuceConverters.scoredValuesToTupleList());
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(nextCursorId), values);
            }

            @Override
            protected void doClose() {
                LettuceZSetCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore(key, min, max), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore(key, min, max), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore(key, min, max, offset, count), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore(key, min, max, offset, count), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore(key, min, max, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)range, "Range for ZRANGEBYSCORE must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore(key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore(key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore(key, LettuceConverters.toRange(range)));
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore(key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)range, "Range for ZRANGEBYLEX must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebylex(key, LettuceConverters.toRange(range, true)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebylex(key, LettuceConverters.toRange(range, true), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebylex(key, LettuceConverters.toRange(range, true)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebylex(key, LettuceConverters.toRange(range, true), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.bytesListToBytesSet().convert(this.getConnection().zrangebylex(key, LettuceConverters.toRange(range, true)));
            }
            return LettuceConverters.bytesListToBytesSet().convert(this.getConnection().zrangebylex(key, LettuceConverters.toRange(range, true), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    private static ZStoreArgs zStoreArgs(@Nullable RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        args.weights(weights.toArray());
        return args;
    }

    public LettuceZSetCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

