/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.connection.lettuce.RangeConverter;
import org.springframework.data.redis.connection.lettuce.StreamConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.util.Assert;

class LettuceStreamCommands
implements RedisStreamCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(group, "Group name must not be null or empty!");
        Assert.notNull((Object)recordIds, "recordIds must not be null!");
        String[] ids = LettuceStreamCommands.entryIdsToString(recordIds);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xack(key, LettuceConverters.toBytes(group), ids)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xack(key, LettuceConverters.toBytes(group), ids)));
                return null;
            }
            return this.getConnection().xack(key, LettuceConverters.toBytes(group), ids);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record) {
        Assert.notNull(record.getStream(), "Stream must not be null!");
        Assert.notNull(record, "Record must not be null!");
        XAddArgs args = new XAddArgs();
        args.id(record.getId().getValue());
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xadd((byte[])record.getStream(), args, (Map)record.getValue()), RecordId::of));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xadd((byte[])record.getStream(), args, (Map)record.getValue()), RecordId::of));
                return null;
            }
            return RecordId.of(this.getConnection().xadd((byte[])record.getStream(), args, (Map)record.getValue()));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)recordIds, "recordIds must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xdel(key, LettuceStreamCommands.entryIdsToString(recordIds))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xdel(key, LettuceStreamCommands.entryIdsToString(recordIds))));
                return null;
            }
            return this.getConnection().xdel(key, LettuceStreamCommands.entryIdsToString(recordIds));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(groupName, "Group name must not be null or empty!");
        Assert.notNull((Object)readOffset, "ReadOffset must not be null!");
        try {
            XReadArgs.StreamOffset<byte[]> streamOffset = XReadArgs.StreamOffset.from(key, readOffset.getOffset());
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xgroupCreate(streamOffset, LettuceConverters.toBytes(groupName))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xgroupCreate(streamOffset, LettuceConverters.toBytes(groupName))));
                return null;
            }
            return this.getConnection().xgroupCreate(streamOffset, LettuceConverters.toBytes(groupName));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)consumer, "Consumer must not be null!");
        try {
            io.lettuce.core.Consumer<byte[]> lettuceConsumer = LettuceStreamCommands.toConsumer(consumer);
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xgroupDelconsumer(key, lettuceConsumer)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xgroupDelconsumer(key, lettuceConsumer)));
                return null;
            }
            return this.getConnection().xgroupDelconsumer(key, lettuceConsumer);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.hasText(groupName, "Group name must not be null or empty!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xgroupDestroy(key, LettuceConverters.toBytes(groupName))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xgroupDestroy(key, LettuceConverters.toBytes(groupName))));
                return null;
            }
            return this.getConnection().xgroupDestroy(key, LettuceConverters.toBytes(groupName));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xlen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xlen(key)));
                return null;
            }
            return this.getConnection().xlen(key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRange(byte[] key, org.springframework.data.domain.Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        Range<String> lettuceRange = RangeConverter.toRange(range, Function.identity());
        Limit lettuceLimit = LettuceConverters.toLimit(limit);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xrange(key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xrange(key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xrange(key, lettuceRange, lettuceLimit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, "StreamReadOptions must not be null!");
        Assert.notNull(streams, "StreamOffsets must not be null!");
        XReadArgs.StreamOffset<byte[]>[] streamOffsets = LettuceStreamCommands.toStreamOffsets(streams);
        XReadArgs args = StreamConverters.toReadArgs(readOptions);
        if (LettuceStreamCommands.isBlocking(readOptions)) {
            try {
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                if (this.isQueueing()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                return StreamConverters.byteRecordListConverter().convert(this.getDedicatedConnection().xread(args, streamOffsets));
            }
            catch (Exception ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xread(args, streamOffsets));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)consumer, "Consumer must not be null!");
        Assert.notNull((Object)readOptions, "StreamReadOptions must not be null!");
        Assert.notNull(streams, "StreamOffsets must not be null!");
        XReadArgs.StreamOffset<byte[]>[] streamOffsets = LettuceStreamCommands.toStreamOffsets(streams);
        XReadArgs args = StreamConverters.toReadArgs(readOptions);
        io.lettuce.core.Consumer<byte[]> lettuceConsumer = LettuceStreamCommands.toConsumer(consumer);
        if (LettuceStreamCommands.isBlocking(readOptions)) {
            try {
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                if (this.isQueueing()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                return StreamConverters.byteRecordListConverter().convert(this.getDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets));
            }
            catch (Exception ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xreadgroup(lettuceConsumer, args, streamOffsets));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRevRange(byte[] key, org.springframework.data.domain.Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        Range<String> lettuceRange = RangeConverter.toRange(range);
        Limit lettuceLimit = LettuceConverters.toLimit(limit);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xrevrange(key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xrevrange(key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return StreamConverters.byteRecordListConverter().convert(this.getConnection().xrevrange(key, lettuceRange, lettuceLimit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xTrim(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xtrim(key, count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xtrim(key, count)));
                return null;
            }
            return this.getConnection().xtrim(key, count);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncDedicatedConnection() {
        return this.connection.getAsyncDedicatedConnection();
    }

    RedisClusterCommands<byte[], byte[]> getDedicatedConnection() {
        return this.connection.getDedicatedConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    private static boolean isBlocking(StreamReadOptions readOptions) {
        return readOptions.getBlock() != null && readOptions.getBlock() > 0L;
    }

    private static XReadArgs.StreamOffset<byte[]>[] toStreamOffsets(StreamOffset<byte[]>[] streams) {
        return (XReadArgs.StreamOffset[])Arrays.stream(streams).map(it -> XReadArgs.StreamOffset.from(it.getKey(), it.getOffset().getOffset())).toArray(XReadArgs.StreamOffset[]::new);
    }

    private static io.lettuce.core.Consumer<byte[]> toConsumer(Consumer consumer) {
        return io.lettuce.core.Consumer.from(LettuceConverters.toBytes(consumer.getGroup()), LettuceConverters.toBytes(consumer.getName()));
    }

    private static String[] entryIdsToString(RecordId[] recordIds) {
        if (recordIds.length == 1) {
            return new String[]{recordIds[0].getValue()};
        }
        return (String[])Arrays.stream(recordIds).map(RecordId::getValue).toArray(String[]::new);
    }

    public LettuceStreamCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

