/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.reactive.BaseRedisReactiveCommands;
import io.lettuce.core.api.reactive.RedisReactiveCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import java.nio.ByteBuffer;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.lettuce.LettuceClusterTopologyProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterHashCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterNumberCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterScriptingCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterServerCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterStreamCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterStringCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveClusterZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveRedisClusterConnection
extends LettuceReactiveRedisConnection
implements ReactiveRedisClusterConnection {
    private final ClusterTopologyProvider topologyProvider;

    LettuceReactiveRedisClusterConnection(LettuceConnectionProvider connectionProvider, RedisClusterClient client) {
        super(connectionProvider);
        this.topologyProvider = new LettuceClusterTopologyProvider(client);
    }

    LettuceReactiveRedisClusterConnection(StatefulConnection<ByteBuffer, ByteBuffer> sharedConnection, LettuceConnectionProvider connectionProvider, RedisClusterClient client) {
        super(sharedConnection, connectionProvider);
        this.topologyProvider = new LettuceClusterTopologyProvider(client);
    }

    @Override
    public LettuceReactiveClusterKeyCommands keyCommands() {
        return new LettuceReactiveClusterKeyCommands(this);
    }

    @Override
    public LettuceReactiveClusterListCommands listCommands() {
        return new LettuceReactiveClusterListCommands(this);
    }

    @Override
    public LettuceReactiveClusterSetCommands setCommands() {
        return new LettuceReactiveClusterSetCommands(this);
    }

    @Override
    public LettuceReactiveClusterZSetCommands zSetCommands() {
        return new LettuceReactiveClusterZSetCommands(this);
    }

    @Override
    public LettuceReactiveClusterHyperLogLogCommands hyperLogLogCommands() {
        return new LettuceReactiveClusterHyperLogLogCommands(this);
    }

    @Override
    public LettuceReactiveClusterStringCommands stringCommands() {
        return new LettuceReactiveClusterStringCommands(this);
    }

    @Override
    public LettuceReactiveClusterGeoCommands geoCommands() {
        return new LettuceReactiveClusterGeoCommands(this);
    }

    @Override
    public LettuceReactiveClusterHashCommands hashCommands() {
        return new LettuceReactiveClusterHashCommands(this);
    }

    @Override
    public LettuceReactiveClusterNumberCommands numberCommands() {
        return new LettuceReactiveClusterNumberCommands(this);
    }

    @Override
    public LettuceReactiveClusterScriptingCommands scriptingCommands() {
        return new LettuceReactiveClusterScriptingCommands(this);
    }

    @Override
    public LettuceReactiveClusterServerCommands serverCommands() {
        return new LettuceReactiveClusterServerCommands(this, this.topologyProvider);
    }

    @Override
    public LettuceReactiveClusterStreamCommands streamCommands() {
        return new LettuceReactiveClusterStreamCommands(this);
    }

    @Override
    public Mono<String> ping(RedisClusterNode node) {
        return this.execute(node, BaseRedisReactiveCommands::ping).next();
    }

    public <T> Flux<T> execute(RedisNode node, LettuceReactiveRedisConnection.LettuceReactiveCallback<T> callback) {
        try {
            Assert.notNull((Object)node, "RedisClusterNode must not be null!");
            Assert.notNull(callback, "ReactiveCallback must not be null!");
        }
        catch (IllegalArgumentException e) {
            return Flux.error(e);
        }
        return this.getCommands(node).flatMapMany(callback::doWithCommands).onErrorMap(this.translateException());
    }

    protected Mono<StatefulRedisClusterConnection<ByteBuffer, ByteBuffer>> getConnection() {
        return super.getConnection();
    }

    protected Mono<RedisClusterReactiveCommands<ByteBuffer, ByteBuffer>> getCommands() {
        return this.getConnection().map(StatefulRedisClusterConnection::reactive);
    }

    protected Mono<RedisReactiveCommands<ByteBuffer, ByteBuffer>> getCommands(RedisNode node) {
        if (StringUtils.hasText(node.getId())) {
            return this.getConnection().cast(StatefulRedisClusterConnection.class).map(it -> it.getConnection(node.getId()).reactive());
        }
        return this.getConnection().flatMap(it -> Mono.fromCompletionStage(it.getConnectionAsync(node.getHost(), node.getPort())).map(StatefulRedisConnection::reactive));
    }
}

