/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.nio.ByteBuffer;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveListCommands
implements ReactiveListCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveListCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.PushCommand, Long>> push(Publisher<ReactiveListCommands.PushCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notEmpty(command.getValues(), "Values must not be null or empty!");
            if (!command.getUpsert() && command.getValues().size() > 1) {
                throw new InvalidDataAccessApiUsageException(String.format("%s PUSHX only allows one value!", new Object[]{command.getDirection()}));
            }
            Mono<Long> pushResult = ObjectUtils.nullSafeEquals((Object)ReactiveListCommands.Direction.RIGHT, (Object)command.getDirection()) ? (command.getUpsert() ? cmd.rpush(command.getKey(), command.getValues().stream().toArray(ByteBuffer[]::new)) : cmd.rpushx(command.getKey(), command.getValues().get(0))) : (command.getUpsert() ? cmd.lpush(command.getKey(), command.getValues().stream().toArray(ByteBuffer[]::new)) : cmd.lpushx(command.getKey(), command.getValues().get(0)));
            return pushResult.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveListCommands.PushCommand, Long>((ReactiveListCommands.PushCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> lLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            return cmd.llen(command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.RangeCommand, Flux<ByteBuffer>>> lRange(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            Range<Long> range = command.getRange();
            Flux result = cmd.lrange(command.getKey(), LettuceConverters.getLowerBoundIndex(range), LettuceConverters.getUpperBoundIndex(range));
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveRedisConnection.RangeCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.RangeCommand>> lTrim(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            Range<Long> range = command.getRange();
            Mono<String> result = cmd.ltrim(command.getKey(), LettuceConverters.getLowerBoundIndex(range), LettuceConverters.getUpperBoundIndex(range));
            return result.map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.RangeCommand>((ReactiveRedisConnection.RangeCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.LIndexCommand>> lIndex(Publisher<ReactiveListCommands.LIndexCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getIndex(), "Index value must not be null!");
            return cmd.lindex(command.getKey(), command.getIndex()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.LIndexCommand>((ReactiveListCommands.LIndexCommand)command, (ByteBuffer)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LInsertCommand, Long>> lInsert(Publisher<ReactiveListCommands.LInsertCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            Assert.notNull((Object)command.getPivot(), "Pivot must not be null!");
            Assert.notNull((Object)command.getPosition(), "Position must not be null!");
            return cmd.linsert(command.getKey(), RedisListCommands.Position.BEFORE.equals((Object)command.getPosition()), command.getPivot(), command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LInsertCommand, Long>((ReactiveListCommands.LInsertCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveListCommands.LSetCommand>> lSet(Publisher<ReactiveListCommands.LSetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "value must not be null!");
            Assert.notNull((Object)command.getIndex(), "Index must not be null!");
            return cmd.lset(command.getKey(), command.getIndex(), command.getValue()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveListCommands.LSetCommand>((ReactiveListCommands.LSetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LRemCommand, Long>> lRem(Publisher<ReactiveListCommands.LRemCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            Assert.notNull((Object)command.getCount(), "Count must not be null!");
            return cmd.lrem(command.getKey(), command.getCount(), command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LRemCommand, Long>((ReactiveListCommands.LRemCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.PopCommand>> pop(Publisher<ReactiveListCommands.PopCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDirection(), "Direction must not be null!");
            Mono popResult = ObjectUtils.nullSafeEquals((Object)ReactiveListCommands.Direction.RIGHT, (Object)command.getDirection()) ? cmd.rpop(command.getKey()) : cmd.lpop(command.getKey());
            return popResult.map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.PopCommand>((ReactiveListCommands.PopCommand)command, (ByteBuffer)value));
        }));
    }

    @Override
    public Flux<ReactiveListCommands.PopResponse> bPop(Publisher<ReactiveListCommands.BPopCommand> commands) {
        return this.connection.executeDedicated(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null!");
            Assert.notNull((Object)command.getDirection(), "Direction must not be null!");
            long timeout = command.getTimeout().get(ChronoUnit.SECONDS);
            Mono<ReactiveListCommands.PopResult> mappedMono = (ObjectUtils.nullSafeEquals((Object)ReactiveListCommands.Direction.RIGHT, (Object)command.getDirection()) ? cmd.brpop(timeout, command.getKeys().stream().toArray(ByteBuffer[]::new)) : cmd.blpop(timeout, command.getKeys().stream().toArray(ByteBuffer[]::new))).map(kv -> Arrays.asList((ByteBuffer)kv.getKey(), (ByteBuffer)kv.getValue())).map(ReactiveListCommands.PopResult::new);
            return mappedMono.map(value -> new ReactiveListCommands.PopResponse((ReactiveListCommands.BPopCommand)command, (ReactiveListCommands.PopResult)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>> rPopLPush(Publisher<ReactiveListCommands.RPopLPushCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDestination(), "Destination key must not be null!");
            return cmd.rpoplpush(command.getKey(), command.getDestination()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>((ReactiveListCommands.RPopLPushCommand)command, (ByteBuffer)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.BRPopLPushCommand>> bRPopLPush(Publisher<ReactiveListCommands.BRPopLPushCommand> commands) {
        return this.connection.executeDedicated(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDestination(), "Destination key must not be null!");
            Assert.notNull((Object)command.getTimeout(), "Timeout must not be null!");
            return cmd.brpoplpush(command.getTimeout().get(ChronoUnit.SECONDS), command.getKey(), command.getDestination()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.BRPopLPushCommand>((ReactiveListCommands.BRPopLPushCommand)command, (ByteBuffer)value));
        }));
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

