/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterZSetCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveZSetCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveClusterZSetCommands
extends LettuceReactiveZSetCommands
implements ReactiveClusterZSetCommands {
    LettuceReactiveClusterZSetCommands(LettuceReactiveRedisConnection connection) {
        super(connection);
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZUnionStoreCommand, Long>> zUnionStore(Publisher<ReactiveZSetCommands.ZUnionStoreCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty.");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getSourceKeys())) {
                return super.zUnionStore(Mono.just(command));
            }
            return Mono.error(new InvalidDataAccessApiUsageException("All keys must map to the same slot for ZUNIONSTORE command."));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZInterStoreCommand, Long>> zInterStore(Publisher<ReactiveZSetCommands.ZInterStoreCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null or empty.");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getSourceKeys())) {
                return super.zInterStore(Mono.just(command));
            }
            return Mono.error(new InvalidDataAccessApiUsageException("All keys must map to the same slot for ZINTERSTORE command."));
        }));
    }
}

