/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface PreferredConstructorDiscoverer<T, P extends PersistentProperty<P>> {
    @Nullable
    public static <T, P extends PersistentProperty<P>> PreferredConstructor<T, P> discover(Class<T> type) {
        Assert.notNull(type, "Type must not be null!");
        return Discoverers.findDiscoverer(type).discover(ClassTypeInformation.from(type), null);
    }

    @Nullable
    public static <T, P extends PersistentProperty<P>> PreferredConstructor<T, P> discover(PersistentEntity<T, P> entity) {
        Assert.notNull(entity, "PersistentEntity must not be null!");
        return Discoverers.findDiscoverer(entity.getType()).discover(entity.getTypeInformation(), entity);
    }

    public static enum Discoverers {
        DEFAULT{

            @Override
            @Nullable
            <T, P extends PersistentProperty<P>> PreferredConstructor<T, P> discover(TypeInformation<T> type, @Nullable PersistentEntity<T, P> entity) {
                boolean noArgConstructorFound = false;
                int numberOfArgConstructors = 0;
                Class<T> rawOwningType = type.getType();
                PreferredConstructor constructor = null;
                for (Constructor<?> candidate : rawOwningType.getDeclaredConstructors()) {
                    PreferredConstructor preferredConstructor = Discoverers.buildPreferredConstructor(candidate, type, entity);
                    if (preferredConstructor.getConstructor().isSynthetic()) continue;
                    if (preferredConstructor.isExplicitlyAnnotated()) {
                        return preferredConstructor;
                    }
                    if (constructor == null || preferredConstructor.isNoArgConstructor()) {
                        constructor = preferredConstructor;
                    }
                    if (preferredConstructor.isNoArgConstructor()) {
                        noArgConstructorFound = true;
                        continue;
                    }
                    ++numberOfArgConstructors;
                }
                if (!noArgConstructorFound && numberOfArgConstructors > 1) {
                    constructor = null;
                }
                return constructor;
            }
        }
        ,
        KOTLIN{

            @Override
            @Nullable
            <T, P extends PersistentProperty<P>> PreferredConstructor<T, P> discover(TypeInformation<T> type, @Nullable PersistentEntity<T, P> entity) {
                Class<T> rawOwningType = type.getType();
                return Arrays.stream(rawOwningType.getDeclaredConstructors()).map(it -> Discoverers.buildPreferredConstructor(it, type, entity)).filter(it -> !it.getConstructor().isSynthetic()).filter(PreferredConstructor::isExplicitlyAnnotated).findFirst().orElseGet(() -> {
                    KFunction primaryConstructor = KClasses.getPrimaryConstructor((KClass)JvmClassMappingKt.getKotlinClass(type.getType()));
                    if (primaryConstructor == null) {
                        return DEFAULT.discover(type, entity);
                    }
                    Constructor javaConstructor = ReflectJvmMapping.getJavaConstructor((KFunction)primaryConstructor);
                    return javaConstructor != null ? Discoverers.buildPreferredConstructor(javaConstructor, type, entity) : null;
                });
            }
        };

        private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER;

        private static Discoverers findDiscoverer(Class<?> type) {
            return ReflectionUtils.isSupportedKotlinClass(type) ? KOTLIN : DEFAULT;
        }

        @Nullable
        abstract <T, P extends PersistentProperty<P>> PreferredConstructor<T, P> discover(TypeInformation<T> var1, @Nullable PersistentEntity<T, P> var2);

        private static <T, P extends PersistentProperty<P>> PreferredConstructor<T, P> buildPreferredConstructor(Constructor<?> constructor, TypeInformation<T> typeInformation, @Nullable PersistentEntity<T, P> entity) {
            List<TypeInformation<?>> parameterTypes = typeInformation.getParameterTypes(constructor);
            if (parameterTypes.isEmpty()) {
                return new PreferredConstructor(constructor, new PreferredConstructor.Parameter[0]);
            }
            String[] parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(constructor);
            PreferredConstructor.Parameter[] parameters = new PreferredConstructor.Parameter[parameterTypes.size()];
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            for (int i2 = 0; i2 < parameterTypes.size(); ++i2) {
                String name = parameterNames == null ? null : parameterNames[i2];
                TypeInformation<?> type = parameterTypes.get(i2);
                Annotation[] annotations = parameterAnnotations[i2];
                parameters[i2] = new PreferredConstructor.Parameter(name, type, annotations, entity);
            }
            return new PreferredConstructor(constructor, parameters);
        }

        static {
            PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
        }
    }
}

