/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.KeyValueRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public class SimpleKeyValueRepository<T, ID>
implements KeyValueRepository<T, ID> {
    private final KeyValueOperations operations;
    private final EntityInformation<T, ID> entityInformation;

    public SimpleKeyValueRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations) {
        Assert.notNull(metadata, "EntityInformation must not be null!");
        Assert.notNull((Object)operations, "KeyValueOperations must not be null!");
        this.entityInformation = metadata;
        this.operations = operations;
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        return this.operations.findAll(sort, this.entityInformation.getJavaType());
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, "Pageable must not be null!");
        if (pageable.isUnpaged()) {
            Iterable result = this.findAll();
            return new PageImpl(result, Pageable.unpaged(), result.size());
        }
        Iterable content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), this.entityInformation.getJavaType());
        return new PageImpl(IterableConverter.toList(content), pageable, this.operations.count(this.entityInformation.getJavaType()));
    }

    @Override
    public <S extends T> S save(S entity) {
        Assert.notNull(entity, "Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.operations.insert(entity);
        }
        return this.operations.update(this.entityInformation.getRequiredId(entity), entity);
    }

    @Override
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        ArrayList<S> saved = new ArrayList<S>();
        for (S entity : entities) {
            saved.add(this.save(entity));
        }
        return saved;
    }

    @Override
    public Optional<T> findById(ID id) {
        return this.operations.findById(id, this.entityInformation.getJavaType());
    }

    @Override
    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    @Override
    public List<T> findAll() {
        return IterableConverter.toList(this.operations.findAll(this.entityInformation.getJavaType()));
    }

    @Override
    public Iterable<T> findAllById(Iterable<ID> ids) {
        ArrayList result = new ArrayList();
        ids.forEach(id -> this.findById(id).ifPresent(result::add));
        return result;
    }

    @Override
    public long count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    @Override
    public void deleteById(ID id) {
        this.operations.delete(id, this.entityInformation.getJavaType());
    }

    @Override
    public void delete(T entity) {
        this.deleteById(this.entityInformation.getRequiredId(entity));
    }

    @Override
    public void deleteAll(Iterable<? extends T> entities) {
        entities.forEach(this::delete);
    }

    @Override
    public void deleteAll() {
        this.operations.delete(this.entityInformation.getJavaType());
    }
}

