/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Shape;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Polygon
implements Iterable<Point>,
Shape {
    private static final long serialVersionUID = -2705040068154648988L;
    private final List<Point> points;

    public Polygon(Point x, Point y, Point z, Point ... others) {
        Assert.notNull((Object)x, "X coordinate must not be null!");
        Assert.notNull((Object)y, "Y coordinate must not be null!");
        Assert.notNull((Object)z, "Z coordinate must not be null!");
        Assert.notNull((Object)others, "Others must not be null!");
        ArrayList<Point> points = new ArrayList<Point>(3 + others.length);
        points.addAll(Arrays.asList(x, y, z));
        points.addAll(Arrays.asList(others));
        this.points = Collections.unmodifiableList(points);
    }

    @PersistenceConstructor
    public Polygon(List<? extends Point> points) {
        Assert.notNull(points, "Points must not be null!");
        ArrayList<Point> pointsToSet = new ArrayList<Point>(points.size());
        for (Point point : points) {
            Assert.notNull((Object)point, "Single Point in Polygon must not be null!");
            pointsToSet.add(point);
        }
        this.points = Collections.unmodifiableList(pointsToSet);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    @Override
    public Iterator<Point> iterator() {
        return this.points.iterator();
    }

    public String toString() {
        return String.format("Polygon: [%s]", StringUtils.collectionToCommaDelimitedString(this.points));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Polygon)) {
            return false;
        }
        Polygon other = (Polygon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Point> this$points = this.getPoints();
        List<Point> other$points = other.getPoints();
        return !(this$points == null ? other$points != null : !((Object)this$points).equals(other$points));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Polygon;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Point> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        return result;
    }
}

