/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.crossstore;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.crossstore.ChangeSetBacked;
import org.springframework.data.crossstore.ChangeSetPersister;
import org.springframework.transaction.support.TransactionSynchronization;

public class ChangeSetBackedTransactionSynchronization
implements TransactionSynchronization {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ChangeSetPersister<Object> changeSetPersister;
    private final ChangeSetBacked entity;
    private int changeSetTxStatus = -1;

    public ChangeSetBackedTransactionSynchronization(ChangeSetPersister<Object> changeSetPersister, ChangeSetBacked entity) {
        this.changeSetPersister = changeSetPersister;
        this.entity = entity;
    }

    @Override
    public void afterCommit() {
        this.log.debug("After Commit called for " + this.entity);
        this.changeSetPersister.persistState(this.entity, this.entity.getChangeSet());
        this.changeSetTxStatus = 0;
    }

    @Override
    public void afterCompletion(int status) {
        this.log.debug("After Completion called with status = " + status);
        if (this.changeSetTxStatus == 0) {
            if (status == 0) {
                this.log.debug("ChangedSetBackedTransactionSynchronization completed successfully for " + this.entity);
            } else {
                this.log.error("ChangedSetBackedTransactionSynchronization failed for " + this.entity);
            }
        }
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void resume() {
        throw new IllegalStateException("ChangedSetBackedTransactionSynchronization does not support transaction suspension currently.");
    }

    @Override
    public void suspend() {
        throw new IllegalStateException("ChangedSetBackedTransactionSynchronization does not support transaction suspension currently.");
    }
}

