/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import io.rsocket.RSocketFactory;
import io.rsocket.SocketAcceptor;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.WebsocketRouteTransport;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.rsocket.server.ServerRSocketFactoryProcessor;
import org.springframework.boot.web.embedded.netty.NettyRouteProvider;
import reactor.netty.http.server.HttpServerRoutes;

class RSocketWebSocketNettyRouteProvider
implements NettyRouteProvider {
    private final String mappingPath;
    private final SocketAcceptor socketAcceptor;
    private final List<ServerRSocketFactoryProcessor> processors;

    RSocketWebSocketNettyRouteProvider(String mappingPath, SocketAcceptor socketAcceptor, Stream<ServerRSocketFactoryProcessor> processors) {
        this.mappingPath = mappingPath;
        this.socketAcceptor = socketAcceptor;
        this.processors = processors.collect(Collectors.toList());
    }

    @Override
    public HttpServerRoutes apply(HttpServerRoutes httpServerRoutes) {
        RSocketFactory.ServerRSocketFactory server = RSocketFactory.receive();
        for (ServerRSocketFactoryProcessor processor : this.processors) {
            server = processor.process(server);
        }
        ServerTransport.ConnectionAcceptor acceptor = server.acceptor(this.socketAcceptor).toConnectionAcceptor();
        return httpServerRoutes.ws(this.mappingPath, WebsocketRouteTransport.newHandler((ServerTransport.ConnectionAcceptor)acceptor));
    }
}

