/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import java.util.Map;
import org.apache.dubbo.config.spring.context.properties.DubboConfigBinder;
import org.apache.dubbo.config.spring.util.PropertySourcesUtils;
import org.apache.dubbo.spring.boot.autoconfigure.BinderDubboConfigBinder;
import org.apache.dubbo.spring.boot.autoconfigure.DelegatingPropertyResolver;
import org.apache.dubbo.spring.boot.autoconfigure.DubboRelaxedBindingAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;

@Configuration
@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(name={"org.springframework.boot.context.properties.bind.Binder"})
@AutoConfigureBefore(value={DubboRelaxedBindingAutoConfiguration.class})
public class DubboRelaxedBinding2AutoConfiguration {
    @Bean(name={"dubboScanBasePackagesPropertyResolver"})
    public PropertyResolver dubboScanBasePackagesPropertyResolver(final ConfigurableEnvironment environment2) {
        AbstractEnvironment propertyResolver = new AbstractEnvironment(){

            @Override
            protected void customizePropertySources(MutablePropertySources propertySources) {
                Map<String, Object> dubboScanProperties = PropertySourcesUtils.getSubProperties(environment2, "dubbo.scan.");
                propertySources.addLast(new MapPropertySource("dubboScanProperties", dubboScanProperties));
            }
        };
        ConfigurationPropertySources.attach(propertyResolver);
        return new DelegatingPropertyResolver(propertyResolver);
    }

    @ConditionalOnMissingBean(name={"relaxedDubboConfigBinder"}, value={DubboConfigBinder.class})
    @Bean(value={"relaxedDubboConfigBinder"})
    @Scope(scopeName="prototype")
    public DubboConfigBinder relaxedDubboConfigBinder() {
        return new BinderDubboConfigBinder();
    }
}

