/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.rpc.model.ProviderMethodModel;

public class ProviderModel {
    private final String serviceName;
    private final Object serviceInstance;
    private final Class<?> serviceInterfaceClass;
    private final Map<String, List<ProviderMethodModel>> methods = new HashMap<String, List<ProviderMethodModel>>();

    public ProviderModel(String serviceName, Object serviceInstance, Class<?> serviceInterfaceClass) {
        if (null == serviceInstance) {
            throw new IllegalArgumentException("Service[" + serviceName + "]Target is NULL.");
        }
        this.serviceName = serviceName;
        this.serviceInstance = serviceInstance;
        this.serviceInterfaceClass = serviceInterfaceClass;
        this.initMethod();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceInterfaceClass;
    }

    public Object getServiceInstance() {
        return this.serviceInstance;
    }

    public List<ProviderMethodModel> getAllMethods() {
        ArrayList<ProviderMethodModel> result = new ArrayList<ProviderMethodModel>();
        for (List<ProviderMethodModel> models : this.methods.values()) {
            result.addAll(models);
        }
        return result;
    }

    public ProviderMethodModel getMethodModel(String methodName, String[] argTypes) {
        List<ProviderMethodModel> methodModels = this.methods.get(methodName);
        if (methodModels != null) {
            for (ProviderMethodModel methodModel : methodModels) {
                if (!Arrays.equals(argTypes, methodModel.getMethodArgTypes())) continue;
                return methodModel;
            }
        }
        return null;
    }

    private void initMethod() {
        Method[] methodsToExport = null;
        for (Method method : methodsToExport = this.serviceInterfaceClass.getMethods()) {
            method.setAccessible(true);
            List<ProviderMethodModel> methodModels = this.methods.get(method.getName());
            if (methodModels == null) {
                methodModels = new ArrayList<ProviderMethodModel>(1);
                this.methods.put(method.getName(), methodModels);
            }
            methodModels.add(new ProviderMethodModel(method, this.serviceName));
        }
    }
}

