/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.spring.context.event.ServiceBeanExportedEvent;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.apache.dubbo.config.spring.util.BeanFactoryUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ServiceBean<T>
extends ServiceConfig<T>
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
BeanNameAware,
ApplicationEventPublisherAware {
    private static final long serialVersionUID = 213195494150089726L;
    private final transient Service service;
    private transient ApplicationContext applicationContext;
    private transient String beanName;
    private transient boolean supportedApplicationListener;
    private ApplicationEventPublisher applicationEventPublisher;

    public ServiceBean() {
        this.service = null;
    }

    public ServiceBean(Service service) {
        super(service);
        this.service = service;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
        this.supportedApplicationListener = BeanFactoryUtils.addApplicationListener(applicationContext, this);
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.isExported() && !this.isUnexported()) {
            if (logger.isInfoEnabled()) {
                logger.info("The service ready on spring started. service: " + this.getInterface());
            }
            this.export();
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getProvider() == null) {
            Map<String, ProviderConfig> providerConfigMap;
            Map<String, ProviderConfig> map = providerConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ProviderConfig.class, false, false);
            if (providerConfigMap != null && providerConfigMap.size() > 0) {
                Map<String, ProtocolConfig> protocolConfigMap;
                Map<String, ProtocolConfig> map2 = protocolConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ProtocolConfig.class, false, false);
                if (CollectionUtils.isEmptyMap(protocolConfigMap) && providerConfigMap.size() > 1) {
                    ArrayList<ProviderConfig> providerConfigs = new ArrayList<ProviderConfig>();
                    for (ProviderConfig config : providerConfigMap.values()) {
                        if (config.isDefault() == null || !config.isDefault().booleanValue()) continue;
                        providerConfigs.add(config);
                    }
                    if (!providerConfigs.isEmpty()) {
                        this.setProviders(providerConfigs);
                    }
                } else {
                    ProviderConfig providerConfig = null;
                    for (ProviderConfig config : providerConfigMap.values()) {
                        if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                        if (providerConfig != null) {
                            throw new IllegalStateException("Duplicate provider configs: " + providerConfig + " and " + config);
                        }
                        providerConfig = config;
                    }
                    if (providerConfig != null) {
                        this.setProvider(providerConfig);
                    }
                }
            }
        }
        if (this.getApplication() == null && (this.getProvider() == null || this.getProvider().getApplication() == null)) {
            Map<String, ApplicationConfig> applicationConfigMap;
            Map<String, ApplicationConfig> map = applicationConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ApplicationConfig.class, false, false);
            if (applicationConfigMap != null && applicationConfigMap.size() > 0) {
                ApplicationConfig applicationConfig = null;
                for (ApplicationConfig applicationConfig2 : applicationConfigMap.values()) {
                    if (applicationConfig != null) {
                        throw new IllegalStateException("Duplicate application configs: " + applicationConfig + " and " + applicationConfig2);
                    }
                    applicationConfig = applicationConfig2;
                }
                if (applicationConfig != null) {
                    this.setApplication(applicationConfig);
                }
            }
        }
        if (this.getModule() == null && (this.getProvider() == null || this.getProvider().getModule() == null)) {
            Map<String, ModuleConfig> moduleConfigMap;
            Map<String, ModuleConfig> map = moduleConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ModuleConfig.class, false, false);
            if (moduleConfigMap != null && moduleConfigMap.size() > 0) {
                ModuleConfig moduleConfig = null;
                for (ModuleConfig moduleConfig2 : moduleConfigMap.values()) {
                    if (moduleConfig2.isDefault() != null && !moduleConfig2.isDefault().booleanValue()) continue;
                    if (moduleConfig != null) {
                        throw new IllegalStateException("Duplicate module configs: " + moduleConfig + " and " + moduleConfig2);
                    }
                    moduleConfig = moduleConfig2;
                }
                if (moduleConfig != null) {
                    this.setModule(moduleConfig);
                }
            }
        }
        if (StringUtils.isEmpty(this.getRegistryIds())) {
            if (this.getApplication() != null && StringUtils.isNotEmpty(this.getApplication().getRegistryIds())) {
                this.setRegistryIds(this.getApplication().getRegistryIds());
            }
            if (this.getProvider() != null && StringUtils.isNotEmpty(this.getProvider().getRegistryIds())) {
                this.setRegistryIds(this.getProvider().getRegistryIds());
            }
        }
        if (CollectionUtils.isEmpty(this.getRegistries()) && (this.getProvider() == null || CollectionUtils.isEmpty(this.getProvider().getRegistries())) && (this.getApplication() == null || CollectionUtils.isEmpty(this.getApplication().getRegistries()))) {
            Map<String, RegistryConfig> registryConfigMap;
            Map<String, RegistryConfig> map = registryConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, RegistryConfig.class, false, false);
            if (CollectionUtils.isNotEmptyMap(registryConfigMap)) {
                ArrayList<RegistryConfig> registryConfigs = new ArrayList<RegistryConfig>();
                if (StringUtils.isNotEmpty(this.registryIds)) {
                    Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(this.registryIds)).forEach(id -> {
                        if (registryConfigMap.containsKey(id)) {
                            registryConfigs.add((AbstractConfig)registryConfigMap.get(id));
                        }
                    });
                }
                if (registryConfigs.isEmpty()) {
                    for (RegistryConfig registryConfig : registryConfigMap.values()) {
                        if (!StringUtils.isEmpty(this.registryIds)) continue;
                        registryConfigs.add(registryConfig);
                    }
                }
                if (!registryConfigs.isEmpty()) {
                    super.setRegistries(registryConfigs);
                }
            }
        }
        if (this.getMetadataReportConfig() == null) {
            Map<String, MetadataReportConfig> metadataReportConfigMap;
            Map<String, MetadataReportConfig> map = metadataReportConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MetadataReportConfig.class, false, false);
            if (metadataReportConfigMap != null && metadataReportConfigMap.size() == 1) {
                super.setMetadataReportConfig(metadataReportConfigMap.values().iterator().next());
            } else if (metadataReportConfigMap != null && metadataReportConfigMap.size() > 1) {
                throw new IllegalStateException("Multiple MetadataReport configs: " + metadataReportConfigMap);
            }
        }
        if (this.getConfigCenter() == null) {
            Map<String, ConfigCenterConfig> configenterMap;
            Map<String, ConfigCenterConfig> map = configenterMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ConfigCenterConfig.class, false, false);
            if (configenterMap != null && configenterMap.size() == 1) {
                super.setConfigCenter(configenterMap.values().iterator().next());
            } else if (configenterMap != null && configenterMap.size() > 1) {
                throw new IllegalStateException("Multiple ConfigCenter found:" + configenterMap);
            }
        }
        if (!(this.getMonitor() != null || this.getProvider() != null && this.getProvider().getMonitor() != null || this.getApplication() != null && this.getApplication().getMonitor() != null)) {
            Map<String, MonitorConfig> monitorConfigMap;
            Map<String, MonitorConfig> map = monitorConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MonitorConfig.class, false, false);
            if (monitorConfigMap != null && monitorConfigMap.size() > 0) {
                MonitorConfig monitorConfig = null;
                for (MonitorConfig monitorConfig2 : monitorConfigMap.values()) {
                    if (monitorConfig2.isDefault() != null && !monitorConfig2.isDefault().booleanValue()) continue;
                    if (monitorConfig != null) {
                        throw new IllegalStateException("Duplicate monitor configs: " + monitorConfig + " and " + monitorConfig2);
                    }
                    monitorConfig = monitorConfig2;
                }
                if (monitorConfig != null) {
                    this.setMonitor(monitorConfig);
                }
            }
        }
        if (this.getMetrics() == null) {
            Map<String, MetricsConfig> metricsConfigMap;
            Map<String, MetricsConfig> map = metricsConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MetricsConfig.class, false, false);
            if (metricsConfigMap != null && metricsConfigMap.size() > 0) {
                MetricsConfig metricsConfig = null;
                for (MetricsConfig metricsConfig2 : metricsConfigMap.values()) {
                    if (metricsConfig != null) {
                        throw new IllegalStateException("Duplicate metrics configs: " + metricsConfig + " and " + metricsConfig2);
                    }
                    metricsConfig = metricsConfig2;
                }
                if (metricsConfig != null) {
                    this.setMetrics(metricsConfig);
                }
            }
        }
        if (StringUtils.isEmpty(this.getProtocolIds()) && this.getProvider() != null && StringUtils.isNotEmpty(this.getProvider().getProtocolIds())) {
            this.setProtocolIds(this.getProvider().getProtocolIds());
        }
        if (CollectionUtils.isEmpty(this.getProtocols()) && (this.getProvider() == null || CollectionUtils.isEmpty(this.getProvider().getProtocols()))) {
            Map<String, ProtocolConfig> protocolConfigMap;
            Map<String, ProtocolConfig> map = protocolConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ProtocolConfig.class, false, false);
            if (protocolConfigMap != null && protocolConfigMap.size() > 0) {
                ArrayList<ProtocolConfig> protocolConfigs = new ArrayList<ProtocolConfig>();
                if (StringUtils.isNotEmpty(this.getProtocolIds())) {
                    Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(this.getProtocolIds())).forEach(id -> {
                        if (protocolConfigMap.containsKey(id)) {
                            protocolConfigs.add((AbstractConfig)protocolConfigMap.get(id));
                        }
                    });
                }
                if (protocolConfigs.isEmpty()) {
                    for (ProtocolConfig protocolConfig : protocolConfigMap.values()) {
                        if (!StringUtils.isEmpty(this.protocolIds)) continue;
                        protocolConfigs.add(protocolConfig);
                    }
                }
                if (!protocolConfigs.isEmpty()) {
                    super.setProtocols(protocolConfigs);
                }
            }
        }
        if (StringUtils.isEmpty(this.getPath()) && StringUtils.isNotEmpty(this.beanName) && StringUtils.isNotEmpty(this.getInterface()) && this.beanName.startsWith(this.getInterface())) {
            this.setPath(this.beanName);
        }
        if (!this.supportedApplicationListener) {
            this.export();
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void export() {
        super.export();
        this.publishExportEvent();
    }

    private void publishExportEvent() {
        ServiceBeanExportedEvent exportEvent = new ServiceBeanExportedEvent(this);
        this.applicationEventPublisher.publishEvent(exportEvent);
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    protected Class getServiceClass(T ref) {
        if (AopUtils.isAopProxy(ref)) {
            return AopUtils.getTargetClass(ref);
        }
        return super.getServiceClass(ref);
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

